"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionDurationChart = void 0;
exports.padOrTruncateDurations = padOrTruncateDurations;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _charts = require("@elastic/charts");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _execution_duration_utils = require("../../../lib/execution_duration_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NUM_EXECUTIONS_OPTIONS = [120, 60, 30, 15].map(value => ({
  value,
  text: _i18n.i18n.translate('xpack.triggersActionsUI.sections.executionDurationChart.numberOfExecutionsOption', {
    defaultMessage: '{value} runs',
    values: {
      value
    }
  })
}));
const ExecutionDurationChart = ({
  executionDuration,
  numberOfExecutions,
  onChangeDuration,
  isLoading
}) => {
  const paddedExecutionDurations = padOrTruncateDurations(executionDuration.valuesWithTimestamp, numberOfExecutions);
  const onChange = (0, _react.useCallback)(({
    target
  }) => onChangeDuration(Number(target.value)), [onChangeDuration]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "executionDurationChartPanel",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.executionDurationChart.recentDurationsTitle",
    defaultMessage: "Recent run durations"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: "select-number-execution-durations",
    "data-test-subj": "executionDurationChartPanelSelect",
    options: NUM_EXECUTIONS_OPTIONS,
    value: numberOfExecutions,
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.executionDurationChart.selectNumberOfExecutionDurationsLabel', {
      defaultMessage: 'Select number of runs'
    }),
    onChange: onChange
  })))), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      height: '80px',
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl"
  }))), !isLoading && (executionDuration.valuesWithTimestamp && Object.entries(executionDuration.valuesWithTimestamp).length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    "data-test-subj": "executionDurationChart",
    size: {
      height: 80
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings
  // TODO use the EUI charts theme see src/plugins/charts/public/services/theme/README.md
  , {
    theme: {
      lineSeriesStyle: {
        point: {
          visible: false
        },
        line: {
          stroke: _uiTheme.euiLightVars.euiColorAccent
        }
      }
    },
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "executionDuration",
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.executionDurationChart.durationLabel', {
      defaultMessage: `Duration`
    }),
    xScaleType: "linear",
    yScaleType: "linear",
    xAccessor: 0,
    yAccessors: [1],
    data: paddedExecutionDurations.map(([timestamp, val], ndx) => [timestamp ? (0, _moment.default)(timestamp).format('D MMM YYYY @ HH:mm:ss') : ndx, val]),
    minBarHeight: 2
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: "rule_duration_avg",
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.executionDurationChart.avgDurationLabel', {
      defaultMessage: `Avg Duration`
    }),
    xScaleType: "linear",
    yScaleType: "linear",
    xAccessor: 0,
    yAccessors: [1],
    data: paddedExecutionDurations.map(([timestamp, val], ndx) => [timestamp ? (0, _moment.default)(timestamp).format('D MMM YYYY @ HH:mm:ss') : ndx, val ? executionDuration.average : null]),
    curve: _charts.CurveType.CURVE_NATURAL
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    tickFormat: d => (0, _execution_duration_utils.formatMillisForDisplay)(d)
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "executionDurationChartEmpty",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.executionDurationChart.executionDurationNoData",
      defaultMessage: "There is no available run duration information for this rule."
    })))
  }))));
};
exports.ExecutionDurationChart = ExecutionDurationChart;
function padOrTruncateDurations(valuesWithTimestamp, desiredSize) {
  const values = Object.entries(valuesWithTimestamp);
  if (values.length === desiredSize) {
    return values;
  } else if (values.length < desiredSize) {
    return (0, _lodash.assign)((0, _lodash.fill)(new Array(desiredSize), [null, null]), values);
  } else {
    // oldest durations are at the start of the array, so take the last {desiredSize} values
    return values.slice(-desiredSize);
  }
}