"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkActions = useBulkActions;
exports.useBulkUntrackActions = exports.useBulkAddToCaseActions = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _alerts_table_context = require("../contexts/alerts_table_context");
var _types = require("../../../../types");
var _get_leading_control_column = require("../bulk_actions/get_leading_control_column");
var _translations = require("./translations");
var _use_bulk_untrack_alerts = require("./use_bulk_untrack_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filterAlertsAlreadyAttachedToCase = (alerts, caseId) => alerts.filter(alert => !alert.data.some(field => {
  var _field$value;
  return field.field === _ruleDataUtils.ALERT_CASE_IDS && ((_field$value = field.value) === null || _field$value === void 0 ? void 0 : _field$value.some(id => id === caseId));
}));
const getCaseAttachments = ({
  alerts,
  caseId,
  groupAlertsByRule
}) => {
  var _groupAlertsByRule;
  const filteredAlerts = filterAlertsAlreadyAttachedToCase(alerts !== null && alerts !== void 0 ? alerts : [], caseId);
  return (_groupAlertsByRule = groupAlertsByRule === null || groupAlertsByRule === void 0 ? void 0 : groupAlertsByRule(filteredAlerts)) !== null && _groupAlertsByRule !== void 0 ? _groupAlertsByRule : [];
};
const addItemsToInitialPanel = ({
  panels,
  items
}) => {
  if (panels.length > 0) {
    if (panels[0].items) {
      panels[0].items.push(...items);
    }
    return panels;
  } else {
    return [{
      id: 0,
      items
    }];
  }
};
const useBulkAddToCaseActions = ({
  casesConfig,
  refresh,
  clearSelection
}) => {
  var _casesConfig$owner;
  const {
    cases: casesService
  } = (0, _public.useKibana)().services;
  const userCasesPermissions = casesService === null || casesService === void 0 ? void 0 : casesService.helpers.canUseCases((_casesConfig$owner = casesConfig === null || casesConfig === void 0 ? void 0 : casesConfig.owner) !== null && _casesConfig$owner !== void 0 ? _casesConfig$owner : []);
  const CasesContext = casesService === null || casesService === void 0 ? void 0 : casesService.ui.getCasesContext();
  const isCasesContextAvailable = Boolean(casesService && CasesContext);
  const onSuccess = (0, _react.useCallback)(() => {
    refresh();
    clearSelection();
  }, [clearSelection, refresh]);
  const createCaseFlyout = casesService === null || casesService === void 0 ? void 0 : casesService.hooks.useCasesAddToNewCaseFlyout({
    onSuccess
  });
  const selectCaseModal = casesService === null || casesService === void 0 ? void 0 : casesService.hooks.useCasesAddToExistingCaseModal({
    onSuccess,
    noAttachmentsToaster: {
      title: _translations.NO_ALERTS_ADDED_TO_CASE,
      content: _translations.ALERTS_ALREADY_ATTACHED_TO_CASE
    }
  });
  return (0, _react.useMemo)(() => {
    return isCasesContextAvailable && createCaseFlyout && selectCaseModal && userCasesPermissions !== null && userCasesPermissions !== void 0 && userCasesPermissions.create && userCasesPermissions !== null && userCasesPermissions !== void 0 && userCasesPermissions.read ? [{
      label: _translations.ADD_TO_NEW_CASE,
      key: 'attach-new-case',
      'data-test-subj': 'attach-new-case',
      disableOnQuery: true,
      disabledLabel: _translations.ADD_TO_NEW_CASE,
      onClick: alerts => {
        var _casesService$helpers;
        const caseAttachments = alerts ? (_casesService$helpers = casesService === null || casesService === void 0 ? void 0 : casesService.helpers.groupAlertsByRule(alerts)) !== null && _casesService$helpers !== void 0 ? _casesService$helpers : [] : [];
        createCaseFlyout.open({
          attachments: caseAttachments
        });
      }
    }, {
      label: _translations.ADD_TO_EXISTING_CASE,
      key: 'attach-existing-case',
      disableOnQuery: true,
      disabledLabel: _translations.ADD_TO_EXISTING_CASE,
      'data-test-subj': 'attach-existing-case',
      onClick: alerts => {
        selectCaseModal.open({
          getAttachments: ({
            theCase
          }) => {
            if (theCase == null) {
              var _casesService$helpers2;
              return alerts ? (_casesService$helpers2 = casesService === null || casesService === void 0 ? void 0 : casesService.helpers.groupAlertsByRule(alerts)) !== null && _casesService$helpers2 !== void 0 ? _casesService$helpers2 : [] : [];
            }
            return getCaseAttachments({
              alerts,
              caseId: theCase.id,
              groupAlertsByRule: casesService === null || casesService === void 0 ? void 0 : casesService.helpers.groupAlertsByRule
            });
          }
        });
      }
    }] : [];
  }, [casesService === null || casesService === void 0 ? void 0 : casesService.helpers, createCaseFlyout, isCasesContextAvailable, selectCaseModal, userCasesPermissions === null || userCasesPermissions === void 0 ? void 0 : userCasesPermissions.create, userCasesPermissions === null || userCasesPermissions === void 0 ? void 0 : userCasesPermissions.read]);
};
exports.useBulkAddToCaseActions = useBulkAddToCaseActions;
const useBulkUntrackActions = ({
  setIsBulkActionsLoading,
  refresh,
  clearSelection
}) => {
  var _application$capabili, _application$capabili2, _application$capabili3, _application$capabili4, _application$capabili5, _application$capabili6;
  const onSuccess = (0, _react.useCallback)(() => {
    refresh();
    clearSelection();
  }, [clearSelection, refresh]);
  const {
    application
  } = (0, _public.useKibana)().services;
  const {
    mutateAsync: untrackAlerts
  } = (0, _use_bulk_untrack_alerts.useBulkUntrackAlerts)();
  // Check if at least one Observability feature is enabled
  if (!(application !== null && application !== void 0 && application.capabilities)) return [];
  const hasApmPermission = (_application$capabili = application.capabilities.apm) === null || _application$capabili === void 0 ? void 0 : _application$capabili['alerting:show'];
  const hasInfrastructurePermission = (_application$capabili2 = application.capabilities.infrastructure) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.show;
  const hasLogsPermission = (_application$capabili3 = application.capabilities.logs) === null || _application$capabili3 === void 0 ? void 0 : _application$capabili3.show;
  const hasUptimePermission = (_application$capabili4 = application.capabilities.uptime) === null || _application$capabili4 === void 0 ? void 0 : _application$capabili4.show;
  const hasSloPermission = (_application$capabili5 = application.capabilities.slo) === null || _application$capabili5 === void 0 ? void 0 : _application$capabili5.show;
  const hasObservabilityPermission = (_application$capabili6 = application.capabilities.observability) === null || _application$capabili6 === void 0 ? void 0 : _application$capabili6.show;
  if (!hasApmPermission && !hasInfrastructurePermission && !hasLogsPermission && !hasUptimePermission && !hasSloPermission && !hasObservabilityPermission) return [];
  return [{
    label: _translations.MARK_AS_UNTRACKED,
    key: 'mark-as-untracked',
    disableOnQuery: true,
    disabledLabel: _translations.MARK_AS_UNTRACKED,
    'data-test-subj': 'mark-as-untracked',
    onClick: async alerts => {
      if (!alerts) return;
      const alertUuids = alerts.map(alert => alert._id);
      const indices = alerts.map(alert => {
        var _alert$_index;
        return (_alert$_index = alert._index) !== null && _alert$_index !== void 0 ? _alert$_index : '';
      });
      try {
        setIsBulkActionsLoading(true);
        await untrackAlerts({
          indices,
          alertUuids
        });
        onSuccess();
      } finally {
        setIsBulkActionsLoading(false);
      }
    }
  }];
};
exports.useBulkUntrackActions = useBulkUntrackActions;
function useBulkActions({
  alerts,
  casesConfig,
  query,
  refresh,
  useBulkActionsConfig = () => [],
  featureIds
}) {
  const {
    bulkActions: [bulkActionsState, updateBulkActionsState]
  } = (0, _react.useContext)(_alerts_table_context.AlertsTableContext);
  const configBulkActionPanels = useBulkActionsConfig(query);
  const clearSelection = (0, _react.useCallback)(() => {
    updateBulkActionsState({
      action: _types.BulkActionsVerbs.clear
    });
  }, [updateBulkActionsState]);
  const setIsBulkActionsLoading = (isLoading = true) => {
    updateBulkActionsState({
      action: _types.BulkActionsVerbs.updateAllLoadingState,
      isLoading
    });
  };
  const caseBulkActions = useBulkAddToCaseActions({
    casesConfig,
    refresh,
    clearSelection
  });
  const untrackBulkActions = useBulkUntrackActions({
    setIsBulkActionsLoading,
    refresh,
    clearSelection
  });
  const initialItems = [...caseBulkActions,
  // SECURITY SOLUTION WORKAROUND: Disable untrack action for SIEM
  ...(featureIds !== null && featureIds !== void 0 && featureIds.includes('siem') ? [] : untrackBulkActions)];
  const bulkActions = initialItems.length ? addItemsToInitialPanel({
    panels: configBulkActionPanels,
    items: initialItems
  }) : configBulkActionPanels;
  const isBulkActionsColumnActive = bulkActions.length !== 0;
  (0, _react.useEffect)(() => {
    updateBulkActionsState({
      action: _types.BulkActionsVerbs.rowCountUpdate,
      rowCount: alerts.length
    });
  }, [alerts, updateBulkActionsState]);
  return {
    isBulkActionsColumnActive,
    getBulkActionsLeadingControlColumn: _get_leading_control_column.getLeadingControlColumn,
    bulkActionsState,
    bulkActions,
    setIsBulkActionsLoading,
    clearSelection
  };
}