"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUnmuteAlert = void 0;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _alerts_table_context = require("../../contexts/alerts_table_context");
var _unmute_alert = require("../../../../lib/rule_api/unmute_alert");
var _ = require("../../../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.unmuteAlert.error', {
  defaultMessage: 'Error unmuting alert'
});
const useUnmuteAlert = () => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _.useKibana)().services;
  return (0, _reactQuery.useMutation)(({
    ruleId,
    alertInstanceId
  }) => (0, _unmute_alert.unmuteAlertInstance)({
    http,
    id: ruleId,
    instanceId: alertInstanceId
  }), {
    context: _alerts_table_context.AlertsTableQueryContext,
    onSuccess() {
      toasts.addSuccess(_i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.alertUnuted', {
        defaultMessage: 'Alert unmuted'
      }));
    },
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: ERROR_TITLE
        });
      }
    }
  });
};
exports.useUnmuteAlert = useUnmuteAlert;