"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetMutedAlerts = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _get_rules_muted_alerts = require("../apis/get_rules_muted_alerts");
var _common = require("../../../../../common");
var _constants = require("../../../../hooks/constants");
var _alerts_table_context = require("../../contexts/alerts_table_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.mutedAlerts.api.get', {
  defaultMessage: 'Error fetching muted alerts data'
});
const useGetMutedAlerts = (ruleIds, enabled = true) => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _common.useKibana)().services;
  return (0, _reactQuery.useQuery)(_constants.triggersActionsUiQueriesKeys.mutedAlerts(), ({
    signal
  }) => (0, _get_rules_muted_alerts.getMutedAlerts)(http, {
    ids: ruleIds
  }, signal).then(({
    data: rules
  }) => rules === null || rules === void 0 ? void 0 : rules.reduce((mutedAlerts, rule) => {
    mutedAlerts[rule.id] = rule.muted_alert_ids;
    return mutedAlerts;
  }, {})), {
    context: _alerts_table_context.AlertsTableQueryContext,
    enabled: ruleIds.length > 0 && enabled,
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: ERROR_TITLE
        });
      }
    }
  });
};
exports.useGetMutedAlerts = useGetMutedAlerts;