"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAlertsTableConfiguration = registerAlertsTableConfiguration;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const AlertsPageFlyoutHeader = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./alerts_page_flyout_header'))));
const AlertsPageFlyoutBody = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./alerts_page_flyout_body'))));
const useInternalFlyout = () => ({
  body: AlertsPageFlyoutBody,
  header: AlertsPageFlyoutHeader,
  footer: null
});
function registerAlertsTableConfiguration({
  alertsTableConfigurationRegistry
}) {
  alertsTableConfigurationRegistry.register({
    id: _constants.PLUGIN_ID,
    columns: [{
      id: 'event.action',
      displayAsText: 'Alert status',
      initialWidth: 150
    }, {
      id: '@timestamp',
      displayAsText: 'Last updated',
      initialWidth: 250,
      schema: 'datetime'
    }, {
      id: 'kibana.alert.duration.us',
      displayAsText: 'Duration',
      initialWidth: 150,
      schema: 'numeric'
    }, {
      id: 'kibana.alert.reason',
      displayAsText: 'Reason'
    }],
    useInternalFlyout,
    getRenderCellValue: () => props => {
      var _myProps$data$find$va, _myProps$data$find;
      const myProps = props;
      const value = (_myProps$data$find$va = (_myProps$data$find = myProps.data.find(d => d.field === myProps.columnId)) === null || _myProps$data$find === void 0 ? void 0 : _myProps$data$find.value) !== null && _myProps$data$find$va !== void 0 ? _myProps$data$find$va : [];
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value.length ? value.join() : '--');
    },
    sort: [{
      'event.action': {
        order: 'asc'
      }
    }]
  });
}