"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_alerts_table_state = require("../../../../common/get_alerts_table_state");
var _constants = require("../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const consumers = [_ruleDataUtils.AlertConsumers.APM, _ruleDataUtils.AlertConsumers.LOGS, _ruleDataUtils.AlertConsumers.UPTIME, _ruleDataUtils.AlertConsumers.INFRASTRUCTURE];
const AlertsPage = () => {
  const {
    alertsTableConfigurationRegistry
  } = (0, _kibana.useKibana)().services;
  const alertStateProps = {
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    configurationId: _constants.PLUGIN_ID,
    id: `internal-alerts-page`,
    featureIds: consumers,
    query: {
      bool: {
        must: []
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement("section", null, /*#__PURE__*/_react.default.createElement("h1", null, "THIS IS AN INTERNAL TEST PAGE"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, (0, _get_alerts_table_state.getAlertsTableStateLazy)(alertStateProps))));
};
exports.AlertsPage = AlertsPage;