"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertCounts = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _active_alert_counts = require("./active_alert_counts");
var _all_alert_counts = require("./all_alert_counts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertCounts = ({
  activeAlertCount,
  recoveredAlertCount,
  onActiveClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 50,
      wordWrap: 'break-word'
    },
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_all_alert_counts.AllAlertCounts, {
    count: activeAlertCount + recoveredAlertCount
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 50,
      wordWrap: 'break-word'
    },
    grow: false
  }, !!onActiveClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: event => onActiveClick(event, _ruleDataUtils.ALERT_STATUS_ACTIVE),
    "data-test-subj": "activeAlerts"
  }, /*#__PURE__*/_react.default.createElement(_active_alert_counts.ActiveAlertCounts, {
    activeAlertCount: activeAlertCount
  })) : /*#__PURE__*/_react.default.createElement(_active_alert_counts.ActiveAlertCounts, {
    activeAlertCount: activeAlertCount
  })));
};
exports.AlertCounts = AlertCounts;