"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionAlertsFilterTimeframe = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _common = require("@kbn/alerting-plugin/common");
var _constants = require("../../../common/constants");
var _moment$tz$names$map, _moment$tz;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const TIMEZONE_OPTIONS = (_moment$tz$names$map = (_moment$tz = _moment.default.tz) === null || _moment$tz === void 0 ? void 0 : _moment$tz.names().map(n => ({
  label: n
}))) !== null && _moment$tz$names$map !== void 0 ? _moment$tz$names$map : [{
  label: 'UTC'
}];
const useSortedWeekdayOptions = () => {
  const kibanaDow = (0, _public.useUiSetting)('dateFormat:dow');
  const startDow = kibanaDow !== null && kibanaDow !== void 0 ? kibanaDow : 'Sunday';
  const startDowIndex = _constants.I18N_WEEKDAY_OPTIONS_DDD.findIndex(o => o.label.startsWith(startDow));
  return [..._constants.I18N_WEEKDAY_OPTIONS_DDD.slice(startDowIndex), ..._constants.I18N_WEEKDAY_OPTIONS_DDD.slice(0, startDowIndex)];
};
const useDefaultTimezone = () => {
  var _moment$tz$guess, _moment$tz2;
  const kibanaTz = (0, _public.useUiSetting)('dateFormat:tz');
  if (!kibanaTz || kibanaTz === 'Browser') return (_moment$tz$guess = (_moment$tz2 = _moment.default.tz) === null || _moment$tz2 === void 0 ? void 0 : _moment$tz2.guess()) !== null && _moment$tz$guess !== void 0 ? _moment$tz$guess : 'UTC';
  return kibanaTz;
};
const useTimeframe = initialTimeframe => {
  const timezone = useDefaultTimezone();
  const DEFAULT_TIMEFRAME = {
    days: [],
    timezone,
    hours: {
      start: '00:00',
      end: '00:00'
    }
  };
  return (0, _react.useState)(initialTimeframe || DEFAULT_TIMEFRAME);
};
const useTimeFormat = () => {
  var _useUiSetting, _dateFormatScaled$fin;
  const dateFormatScaled = (_useUiSetting = (0, _public.useUiSetting)('dateFormat:scaled')) !== null && _useUiSetting !== void 0 ? _useUiSetting : [['PT1M', 'HH:mm']];
  const [, PT1M] = (_dateFormatScaled$fin = dateFormatScaled.find(([key]) => key === 'PT1M')) !== null && _dateFormatScaled$fin !== void 0 ? _dateFormatScaled$fin : ['', 'HH:mm'];
  return PT1M;
};
const ActionAlertsFilterTimeframe = ({
  state,
  onChange
}) => {
  const timeFormat = useTimeFormat();
  const [timeframe, setTimeframe] = useTimeframe(state);
  const [selectedTimezone, setSelectedTimezone] = (0, _react.useState)([{
    label: timeframe.timezone
  }]);
  const timeframeEnabled = (0, _react.useMemo)(() => Boolean(state), [state]);
  const weekdayOptions = useSortedWeekdayOptions();
  (0, _react.useEffect)(() => {
    const nextState = timeframeEnabled ? timeframe : undefined;
    if (!(0, _fastDeepEqual.default)(state, nextState)) onChange(nextState);
  }, [timeframeEnabled, timeframe, state, onChange]);
  const toggleTimeframe = (0, _react.useCallback)(() => onChange(state ? undefined : timeframe), [state, timeframe, onChange]);
  const updateTimeframe = (0, _react.useCallback)(update => {
    setTimeframe({
      ...timeframe,
      ...update
    });
  }, [timeframe, setTimeframe]);
  const onChangeHours = (0, _react.useCallback)(startOrEnd => date => {
    updateTimeframe({
      hours: {
        ...timeframe.hours,
        [startOrEnd]: date.format('HH:mm')
      }
    });
  }, [updateTimeframe, timeframe]);
  const onToggleWeekday = (0, _react.useCallback)(id => {
    if (!timeframe) return;
    const day = Number(id);
    const previouslyHasDay = timeframe.days.includes(day);
    const newDays = previouslyHasDay ? timeframe.days.filter(d => d !== day) : [...timeframe.days, day];
    if (newDays.length !== 0) {
      updateTimeframe({
        days: newDays
      });
    }
  }, [timeframe, updateTimeframe]);
  const selectedWeekdays = (0, _react.useMemo)(() => _common.ISO_WEEKDAYS.reduce((result, day) => ({
    ...result,
    [day]: timeframe.days.includes(day)
  }), {}), [timeframe]);
  const onChangeTimezone = (0, _react.useCallback)(value => {
    setSelectedTimezone(value);
    if (value[0].label) updateTimeframe({
      timezone: value[0].label
    });
  }, [updateTimeframe, setSelectedTimezone]);
  const [startH, startM] = (0, _react.useMemo)(() => timeframe.hours.start.split(':').map(Number), [timeframe]);
  const [endH, endM] = (0, _react.useMemo)(() => timeframe.hours.end.split(':').map(Number), [timeframe]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.ActionAlertsFilterTimeframeToggleLabel', {
      defaultMessage: 'If alert is generated during timeframe'
    }),
    checked: timeframeEnabled,
    onChange: toggleTimeframe,
    "data-test-subj": "alertsFilterTimeframeToggle"
  }), timeframeEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.ActionAlertsFilterTimeframeWeekdays', {
      defaultMessage: 'Days of week'
    }),
    options: weekdayOptions,
    idToSelectedMap: selectedWeekdays,
    type: "multi",
    onChange: onToggleWeekday,
    "data-test-subj": "alertsFilterTimeframeWeekdayButtons"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    fullWidth: true,
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      showTimeSelect: true,
      showTimeSelectOnly: true,
      dateFormat: timeFormat,
      timeFormat: timeFormat,
      selected: (0, _moment.default)().set('hour', startH).set('minute', startM),
      onChange: onChangeHours('start'),
      "data-test-subj": "alertsFilterTimeframeStart"
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      showTimeSelect: true,
      showTimeSelectOnly: true,
      dateFormat: timeFormat,
      timeFormat: timeFormat,
      selected: (0, _moment.default)().set('hour', endH).set('minute', endM),
      onChange: onChangeHours('end'),
      "data-test-subj": "alertsFilterTimeframeEnd"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    prepend: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.ActionAlertsFilterTimeframeTimezoneLabel', {
      defaultMessage: 'Timezone'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: TIMEZONE_OPTIONS,
    selectedOptions: selectedTimezone,
    onChange: onChangeTimezone,
    isClearable: false,
    "data-test-subj": "alertsFilterTimeframeTimezone"
  })))));
};
exports.ActionAlertsFilterTimeframe = ActionAlertsFilterTimeframe;