"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkDisableRules = void 0;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkDisableRules = async ({
  filter,
  ids,
  http
}) => {
  try {
    const body = JSON.stringify({
      ids: ids !== null && ids !== void 0 && ids.length ? ids : undefined,
      ...(filter ? {
        filter: JSON.stringify(filter)
      } : {})
    });
    return http.patch(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rules/_bulk_disable`, {
      body
    });
  } catch (e) {
    throw new Error(`Unable to parse bulk disable params: ${e}`);
  }
};
exports.bulkDisableRules = bulkDisableRules;