"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsFlappingSection = exports.RulesSettingsFlappingFormRight = exports.RulesSettingsFlappingFormLeft = exports.RulesSettingsFlappingErrorPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _rules_settings_flapping_form_section = require("./rules_settings_flapping_form_section");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flappingDescription = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.flappingDetectionDescription', {
  defaultMessage: 'Detect alerts that switch quickly between active and recovered states and reduce unwanted noise for these flapping alerts.'
});
const flappingOnLabel = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.flappingOnLabel', {
  defaultMessage: 'On (recommended)'
});
const flappingOffLabel = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.flappingOffLabel', {
  defaultMessage: 'Off'
});
const RulesSettingsFlappingErrorPrompt = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "rulesSettingsFlappingErrorPrompt",
    color: "danger",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.modal.flappingErrorPromptTitle",
      defaultMessage: "Unable to load your flapping settings"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.modal.flappingErrorPromptBody",
      defaultMessage: "There was an error loading your flapping settings. Contact your administrator for help"
    }))
  });
});
exports.RulesSettingsFlappingErrorPrompt = RulesSettingsFlappingErrorPrompt;
const RulesSettingsFlappingFormLeft = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    settings,
    onChange,
    isSwitchDisabled
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, flappingDescription))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "rulesSettingsFlappingEnableSwitch",
    label: settings.enabled ? flappingOnLabel : flappingOffLabel,
    checked: settings.enabled,
    disabled: isSwitchDisabled,
    onChange: onChange
  }))));
});
exports.RulesSettingsFlappingFormLeft = RulesSettingsFlappingFormLeft;
const RulesSettingsFlappingFormRight = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    settings,
    onChange,
    canWrite
  } = props;
  if (!settings) {
    return null;
  }
  if (!settings.enabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "rulesSettingsFlappingOffPrompt"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      borderRadius: "none",
      color: "subdued",
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.flapping.flappingSettingsOffDescription",
      defaultMessage: "Alert flapping detection is off. Alerts will be generated based on the rule interval, which might result in higher alert volumes."
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_rules_settings_flapping_form_section.RulesSettingsFlappingFormSection, {
    flappingSettings: settings,
    onChange: onChange,
    canWrite: canWrite
  }));
});
exports.RulesSettingsFlappingFormRight = RulesSettingsFlappingFormRight;
const RulesSettingsFlappingSection = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    onChange,
    settings,
    hasError,
    canShow,
    canWrite
  } = props;
  if (!canShow) {
    return null;
  }
  if (hasError) {
    return /*#__PURE__*/_react.default.createElement(RulesSettingsFlappingErrorPrompt, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "rulesSettingsFlappingSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_rules_settings_flapping_form_section.RulesSettingsFlappingTitle, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(RulesSettingsFlappingFormLeft, {
    isSwitchDisabled: !canWrite,
    settings: settings,
    onChange: e => onChange('enabled', e.target.checked)
  }), /*#__PURE__*/_react.default.createElement(RulesSettingsFlappingFormRight, {
    settings: settings,
    onChange: (key, value) => onChange(key, value),
    canWrite: canWrite
  })));
});
exports.RulesSettingsFlappingSection = RulesSettingsFlappingSection;