"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonEditorWithMessageVariables = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _lib = require("../lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_EDITOR_ERROR_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.components.jsonEditorWithMessageVariable.noEditorErrorTitle', {
  defaultMessage: 'Unable to add message variable'
});
const NO_EDITOR_ERROR_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.components.jsonEditorWithMessageVariable.noEditorErrorMessage', {
  defaultMessage: 'Editor was not found, please refresh page and try again'
});
const {
  useXJsonMode
} = _public.XJson;

// Source ID used to insert text imperatively into the code editor,
// this value is only used to uniquely identify any single edit attempt.
// Multiple editors can use the same ID without any issues.
const EDITOR_SOURCE = 'json-editor-with-message-variables';
const JsonEditorWithMessageVariables = ({
  buttonTitle,
  messageVariables,
  paramsProperty,
  inputTargetValue,
  label,
  errors,
  areaLabel,
  onDocumentsChange,
  helpText,
  onBlur,
  showButtonTitle,
  euiCodeEditorProps = {}
}) => {
  const editorRef = (0, _react.useRef)();
  const editorDisposables = (0, _react.useRef)([]);
  const [showErrorMessage, setShowErrorMessage] = (0, _react.useState)(false);
  const {
    convertToJson,
    setXJson,
    xJson
  } = useXJsonMode(inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : null);
  (0, _react.useEffect)(() => {
    if (!xJson && inputTargetValue) {
      setXJson(inputTargetValue);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [inputTargetValue]);
  const onSelectMessageVariable = variable => {
    const editor = editorRef.current;
    if (!editor) {
      setShowErrorMessage(true);
      return;
    }
    const cursorPosition = editor.getSelection();
    const templatedVar = (0, _lib.templateActionVariable)(variable);
    let newValue = '';
    if (cursorPosition) {
      editor.executeEdits(EDITOR_SOURCE, [{
        range: cursorPosition,
        text: templatedVar
      }]);
      newValue = editor.getValue();
    } else {
      newValue = templatedVar;
    }
    setShowErrorMessage(false);
    setXJson(newValue);
    // Keep the documents in sync with the editor content
    onDocumentsChange(convertToJson(newValue));
  };
  const registerEditorListeners = (0, _react.useCallback)(() => {
    const editor = editorRef.current;
    if (!editor) {
      return;
    }
    editorDisposables.current.push(editor.onDidBlurEditorWidget(() => {
      onBlur === null || onBlur === void 0 ? void 0 : onBlur();
    }));
  }, [onBlur]);
  const unregisterEditorListeners = () => {
    editorDisposables.current.forEach(d => {
      d.dispose();
    });
    editorDisposables.current = [];
  };
  const onEditorMount = editor => {
    editorRef.current = editor;
    registerEditorListeners();
  };
  const renderErrorMessage = () => {
    if (!showErrorMessage) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      color: "danger",
      iconType: "warning",
      title: NO_EDITOR_ERROR_TITLE
    }, /*#__PURE__*/_react.default.createElement("p", null, NO_EDITOR_ERROR_MESSAGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  };
  (0, _react.useEffect)(() => {
    registerEditorListeners();
    return () => unregisterEditorListeners();
  }, [registerEditorListeners]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "actionJsonEditor",
    fullWidth: true,
    error: errors,
    isInvalid: errors && errors.length > 0 && inputTargetValue !== undefined,
    label: label,
    labelAppend: /*#__PURE__*/_react.default.createElement(_alertsUiShared.AddMessageVariables, {
      buttonTitle: buttonTitle,
      messageVariables: messageVariables,
      onSelectEventHandler: onSelectMessageVariable,
      paramsProperty: paramsProperty,
      showButtonTitle: showButtonTitle
    }),
    helpText: helpText
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderErrorMessage(), /*#__PURE__*/_react.default.createElement(_public2.CodeEditor, (0, _extends2.default)({
    languageId: _monaco.XJsonLang.ID,
    options: {
      renderValidationDecorations: xJson ? 'on' : 'off',
      // Disable error underline when empty
      lineNumbers: 'on',
      fontSize: 14,
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      folding: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    },
    value: xJson,
    width: "100%",
    height: "200px",
    "data-test-subj": `${paramsProperty}JsonEditor`,
    "aria-label": areaLabel
  }, euiCodeEditorProps, {
    editorDidMount: onEditorMount,
    onChange: xjson => {
      setXJson(xjson);
      // Keep the documents in sync with the editor content
      onDocumentsChange(convertToJson(xjson));
    }
  }))));
};
exports.JsonEditorWithMessageVariables = JsonEditorWithMessageVariables;