"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformRetentionPolicy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _app_dependencies = require("../../../../app_dependencies");
var _components = require("../../../../components");
var _transform = require("../../../../../../common/types/transform");
var _hooks = require("../../../../hooks");
var _edit_transform_flyout_form_text_input = require("./edit_transform_flyout_form_text_input");
var _use_edit_transform_flyout = require("./use_edit_transform_flyout");
var _errors = require("../../../../../../common/utils/errors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditTransformRetentionPolicy = () => {
  const {
    i18n: i18nStart,
    theme
  } = (0, _app_dependencies.useAppDependencies)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const dataViewId = (0, _use_edit_transform_flyout.useEditTransformFlyout)('dataViewId');
  const formSections = (0, _use_edit_transform_flyout.useEditTransformFlyout)('stateFormSection');
  const retentionPolicyField = (0, _use_edit_transform_flyout.useEditTransformFlyout)('retentionPolicyField');
  const {
    formField,
    formSection
  } = (0, _use_edit_transform_flyout.useEditTransformFlyout)('actions');
  const requestConfig = (0, _use_edit_transform_flyout.useEditTransformFlyout)('config');
  const previewRequest = (0, _react.useMemo)(() => {
    return {
      source: requestConfig.source,
      ...((0, _transform.isPivotTransform)(requestConfig) ? {
        pivot: requestConfig.pivot
      } : {}),
      ...((0, _transform.isLatestTransform)(requestConfig) ? {
        latest: requestConfig.latest
      } : {})
    };
  }, [requestConfig]);
  const {
    error: transformsPreviewError,
    data: transformPreview
  } = (0, _hooks.useGetTransformsPreview)(previewRequest);
  const destIndexAvailableTimeFields = (0, _react.useMemo)(() => {
    if (transformPreview !== null && transformPreview !== void 0 && transformPreview.generated_dest_index) {
      const properties = transformPreview.generated_dest_index.mappings.properties;
      const timeFields = Object.keys(properties).filter(col => properties[col].type === 'date');
      return timeFields;
    }
    return [];
  }, [transformPreview]);
  (0, _react.useEffect)(() => {
    if (transformsPreviewError !== null) {
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.transform.transformList.errorGettingTransformPreview', {
          defaultMessage: 'An error occurred fetching the transform preview'
        }),
        text: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
          text: (0, _errors.getErrorMessage)(transformsPreviewError)
        }), {
          theme,
          i18n: i18nStart
        })
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [transformsPreviewError]);
  const isRetentionPolicyAvailable = destIndexAvailableTimeFields.length > 0;
  const retentionDateFieldOptions = (0, _react.useMemo)(() => {
    return Array.isArray(destIndexAvailableTimeFields) ? destIndexAvailableTimeFields.map(text => ({
      text,
      value: text
    })) : [];
  }, [destIndexAvailableTimeFields]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: isRetentionPolicyAvailable === false ? _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormEetentionPolicyError', {
      defaultMessage: 'Retention policy settings are not available for indices without date fields.'
    }) : ''
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "transformEditRetentionPolicySwitch",
    label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicySwitchLabel', {
      defaultMessage: 'Retention policy'
    }),
    checked: formSections.retentionPolicy.enabled,
    onChange: e => formSection({
      section: 'retentionPolicy',
      enabled: e.target.checked
    }),
    disabled: !isRetentionPolicyAvailable,
    "data-test-subj": "transformEditRetentionPolicySwitch"
  })), formSections.retentionPolicy.enabled && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformEditRetentionPolicyContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }),
  // If data view or date fields info not available
  // gracefully defaults to text input
  dataViewId ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicyFieldLabel', {
      defaultMessage: 'Field'
    }),
    isInvalid: retentionPolicyField.errorMessages.length > 0,
    error: retentionPolicyField.errorMessages,
    helpText: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicyDateFieldHelpText', {
      defaultMessage: 'Select the date field that can be used to identify out of date documents in the destination index.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicyFieldSelectAriaLabel', {
      defaultMessage: 'Date field to set retention policy'
    }),
    "data-test-subj": "transformEditFlyoutRetentionPolicyFieldSelect",
    options: retentionDateFieldOptions,
    value: retentionPolicyField.value,
    onChange: e => formField({
      field: 'retentionPolicyField',
      value: e.target.value
    }),
    hasNoInitialSelection: !retentionDateFieldOptions.map(d => d.text).includes(retentionPolicyField.value)
  })) : /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
    field: "retentionPolicyField",
    label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicyFieldLabel', {
      defaultMessage: 'Field'
    })
  }), /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
    field: "retentionPolicyMaxAge",
    label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicyMaxAgeLabel', {
      defaultMessage: 'Max age'
    })
  })));
};
exports.EditTransformRetentionPolicy = EditTransformRetentionPolicy;