"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _edit_action_name = require("./edit_action_name");
var _use_search_items = require("../../../../hooks/use_search_items");
var _app_dependencies = require("../../../../app_dependencies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEditAction = (forceDisable, transformNodes) => {
  const {
    canCreateTransform
  } = (0, _hooks.useTransformCapabilities)();
  const [config, setConfig] = (0, _react.useState)();
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const [dataViewId, setDataViewId] = (0, _react.useState)();
  const closeFlyout = () => setIsFlyoutVisible(false);
  const {
    getDataViewIdByTitle
  } = (0, _use_search_items.useSearchItems)(undefined);
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const appDeps = (0, _app_dependencies.useAppDependencies)();
  const dataViews = appDeps.data.dataViews;
  const clickHandler = (0, _react.useCallback)(async item => {
    try {
      const dataViewTitle = Array.isArray(item.config.source.index) ? item.config.source.index.join(',') : item.config.source.index;
      const currentDataViewId = getDataViewIdByTitle(dataViewTitle);
      if (currentDataViewId === undefined) {
        toastNotifications.addWarning(_i18n.i18n.translate('xpack.transform.edit.noDataViewErrorPromptText', {
          defaultMessage: 'Unable to get the data view for the transform {transformId}. No data view exists for {dataViewTitle}.',
          values: {
            dataViewTitle,
            transformId: item.id
          }
        }));
      }
      setDataViewId(currentDataViewId);
      setConfig(item.config);
      setIsFlyoutVisible(true);
    } catch (e) {
      toastNotifications.addError(e, {
        title: _i18n.i18n.translate('xpack.transform.edit.errorPromptText', {
          defaultMessage: 'An error occurred checking if source data view exists'
        })
      });
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [dataViews, toastNotifications, getDataViewIdByTitle]);
  const action = (0, _react.useMemo)(() => ({
    name: () => /*#__PURE__*/_react.default.createElement(_edit_action_name.EditActionName, null),
    enabled: () => canCreateTransform && !forceDisable && transformNodes > 0,
    description: _edit_action_name.editActionNameText,
    icon: 'pencil',
    type: 'icon',
    onClick: item => clickHandler(item),
    'data-test-subj': 'transformActionEdit'
  }), [canCreateTransform, clickHandler, forceDisable, transformNodes]);
  return {
    action,
    config,
    closeFlyout,
    isFlyoutVisible,
    dataViewId
  };
};
exports.useEditAction = useEditAction;