"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.needsReauthorization = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const needsReauthorization = transform => {
  var _transform$config, _transform$stats$heal;
  return (0, _mlIsPopulatedObject.isPopulatedObject)((_transform$config = transform.config) === null || _transform$config === void 0 ? void 0 : _transform$config.authorization, ['api_key']) && (0, _mlIsPopulatedObject.isPopulatedObject)(transform.stats) && transform.stats.health.status === _constants.TRANSFORM_HEALTH.red && ((_transform$stats$heal = transform.stats.health.issues) === null || _transform$stats$heal === void 0 ? void 0 : _transform$stats$heal.find(issue => issue.issue === 'Privileges check failed')) !== undefined;
};
exports.needsReauthorization = needsReauthorization;