"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _tests_selection_control = require("./tests_selection_control");
var _transform_selector_control = require("./transform_selector_control");
var _hooks = require("../../app/hooks");
var _app_dependencies = require("../../app/app_dependencies");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TransformHealthRuleTrigger = ({
  ruleParams,
  setRuleParams,
  errors
}) => {
  var _ruleParams$includeTr2, _ruleParams$excludeTr, _ruleParams$excludeTr2;
  const formErrors = Object.values(errors).flat();
  const isFormInvalid = formErrors.length > 0;
  const toast = (0, _app_dependencies.useToastNotifications)();
  const {
    error,
    data
  } = (0, _hooks.useGetTransforms)();
  const transformOptions = (0, _react.useMemo)(() => {
    var _data$transforms$filt;
    return (_data$transforms$filt = data === null || data === void 0 ? void 0 : data.transforms.filter(v => v.config.sync).map(v => v.id)) !== null && _data$transforms$filt !== void 0 ? _data$transforms$filt : [];
  }, [data]);
  const onAlertParamChange = (0, _react.useCallback)(param => update => {
    setRuleParams(param, update);
  }, [setRuleParams]);
  (0, _react.useEffect)(() => {
    if (error !== null) {
      toast.addError(error, {
        title: _i18n.i18n.translate('xpack.transform.alertingRuleTypes.transformHealth.fetchErrorMessage', {
          defaultMessage: 'Unable to fetch transforms'
        })
      });
    }
  }, [error, toast]);
  const excludeTransformOptions = (0, _react.useMemo)(() => {
    var _ruleParams$includeTr;
    if ((_ruleParams$includeTr = ruleParams.includeTransforms) !== null && _ruleParams$includeTr !== void 0 && _ruleParams$includeTr.some(v => v === _constants.ALL_TRANSFORMS_SELECTION)) {
      return transformOptions;
    }
    return null;
  }, [transformOptions, ruleParams.includeTransforms]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": 'transformHealthAlertingRuleForm',
    invalidCallout: 'none',
    error: formErrors,
    isInvalid: isFormInvalid
  }, /*#__PURE__*/_react.default.createElement(_transform_selector_control.TransformSelectorControl, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.alertTypes.transformHealth.includeTransformsLabel",
      defaultMessage: "Include transforms"
    }),
    options: transformOptions,
    selectedOptions: (_ruleParams$includeTr2 = ruleParams.includeTransforms) !== null && _ruleParams$includeTr2 !== void 0 ? _ruleParams$includeTr2 : [],
    onChange: onAlertParamChange('includeTransforms'),
    allowSelectAll: true,
    errors: errors.includeTransforms
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !!(excludeTransformOptions !== null && excludeTransformOptions !== void 0 && excludeTransformOptions.length) || !!((_ruleParams$excludeTr = ruleParams.excludeTransforms) !== null && _ruleParams$excludeTr !== void 0 && _ruleParams$excludeTr.length) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_transform_selector_control.TransformSelectorControl, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.alertTypes.transformHealth.excludeTransformsLabel",
      defaultMessage: "Exclude transforms"
    }),
    options: excludeTransformOptions !== null && excludeTransformOptions !== void 0 ? excludeTransformOptions : [],
    selectedOptions: (_ruleParams$excludeTr2 = ruleParams.excludeTransforms) !== null && _ruleParams$excludeTr2 !== void 0 ? _ruleParams$excludeTr2 : [],
    onChange: onAlertParamChange('excludeTransforms')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, /*#__PURE__*/_react.default.createElement(_tests_selection_control.TestsSelectionControl, {
    config: ruleParams.testsConfig,
    onChange: onAlertParamChange('testsConfig'),
    errors: Array.isArray(errors.testsConfig) ? errors.testsConfig : []
  }));
};

// Default export is required for React.lazy loading

// eslint-disable-next-line import/no-default-export
var _default = TransformHealthRuleTrigger;
exports.default = _default;
module.exports = exports.default;