"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FILTER_FOR_VALUE_KEYBOARD_SHORTCUT = exports.FILTER_FOR_VALUE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _accessibility = require("../../../../common/utils/accessibility");
var _tooltip_with_keyboard_shortcut = require("../../tooltip_with_keyboard_shortcut");
var _utils = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_FOR_VALUE = _i18n.i18n.translate('xpack.timelines.hoverActions.filterIn', {
  defaultMessage: 'Filter In'
});
exports.FILTER_FOR_VALUE = FILTER_FOR_VALUE;
const FILTER_FOR_VALUE_KEYBOARD_SHORTCUT = 'f';
exports.FILTER_FOR_VALUE_KEYBOARD_SHORTCUT = FILTER_FOR_VALUE_KEYBOARD_SHORTCUT;
const FilterForValueButton = /*#__PURE__*/_react.default.memo(({
  Component,
  defaultFocusedButtonRef,
  field,
  filterManager,
  keyboardEvent,
  onFilterAdded,
  ownFocus,
  onClick,
  size,
  showTooltip = false,
  value
}) => {
  const filterForValueFn = (0, _react.useCallback)(() => {
    const makeFilter = currentVal => (currentVal === null || currentVal === void 0 ? void 0 : currentVal.length) === 0 ? (0, _utils.createFilter)(field, undefined) : (0, _utils.createFilter)(field, currentVal);
    const filters = Array.isArray(value) ? value.map(currentVal => makeFilter(currentVal)) : makeFilter(value);
    const activeFilterManager = filterManager;
    if (activeFilterManager != null) {
      activeFilterManager.addFilters(filters);
      if (onFilterAdded != null) {
        onFilterAdded();
      }
    }
    if (onClick != null) {
      onClick();
    }
  }, [field, filterManager, onClick, onFilterAdded, value]);
  (0, _react.useEffect)(() => {
    if (!ownFocus) {
      return;
    }
    if ((keyboardEvent === null || keyboardEvent === void 0 ? void 0 : keyboardEvent.key) === FILTER_FOR_VALUE_KEYBOARD_SHORTCUT) {
      (0, _accessibility.stopPropagationAndPreventDefault)(keyboardEvent);
      filterForValueFn();
    }
  }, [filterForValueFn, keyboardEvent, ownFocus]);
  const button = (0, _react.useMemo)(() => Component ? /*#__PURE__*/_react.default.createElement(Component, {
    "aria-label": FILTER_FOR_VALUE,
    buttonRef: defaultFocusedButtonRef,
    "data-test-subj": "filter-for-value",
    iconType: "plusInCircle",
    onClick: filterForValueFn,
    size: size,
    title: FILTER_FOR_VALUE
  }, FILTER_FOR_VALUE) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": FILTER_FOR_VALUE,
    buttonRef: defaultFocusedButtonRef,
    className: "timelines__hoverActionButton",
    "data-test-subj": "filter-for-value",
    iconSize: "s",
    iconType: "plusInCircle",
    onClick: filterForValueFn,
    size: size
  }), [Component, defaultFocusedButtonRef, filterForValueFn, size]);
  return showTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_tooltip_with_keyboard_shortcut.TooltipWithKeyboardShortcut, {
      additionalScreenReaderOnlyContext: (0, _utils.getAdditionalScreenReaderOnlyContext)({
        field,
        value
      }),
      content: FILTER_FOR_VALUE,
      shortcut: FILTER_FOR_VALUE_KEYBOARD_SHORTCUT,
      showShortcut: ownFocus
    })
  }, button) : button;
});
exports.default = FilterForValueButton;
FilterForValueButton.displayName = 'FilterForValueButton';

// eslint-disable-next-line import/no-default-export