"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserHasSeenNoticeRoute = exports.OptInRoute = exports.LastReportedRoute = exports.INTERNAL_VERSION = exports.GetOptInStatsRoutePathBasedV2 = exports.FetchTelemetryConfigRoutePathBasedV2 = exports.FetchTelemetryConfigRoute = exports.FetchSnapshotTelemetry = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const BASE_INTERNAL_PATH = '/internal/telemetry';
const INTERNAL_VERSION = {
  version: '2'
};

/**
 * Fetch Telemetry Config
 * @public Kept public and path-based because we know other Elastic products fetch the opt-in status via this endpoint.
 */
exports.INTERNAL_VERSION = INTERNAL_VERSION;
const FetchTelemetryConfigRoutePathBasedV2 = '/api/telemetry/v2/config';

/**
 * Fetch Telemetry Config
 * @internal
 */
exports.FetchTelemetryConfigRoutePathBasedV2 = FetchTelemetryConfigRoutePathBasedV2;
const FetchTelemetryConfigRoute = `${BASE_INTERNAL_PATH}/config`;

/**
 * GET/PUT Last reported date for Snapshot telemetry
 * @internal
 */
exports.FetchTelemetryConfigRoute = FetchTelemetryConfigRoute;
const LastReportedRoute = `${BASE_INTERNAL_PATH}/last_reported`;

/**
 * Set user has seen notice
 * @internal
 */
exports.LastReportedRoute = LastReportedRoute;
const UserHasSeenNoticeRoute = `${BASE_INTERNAL_PATH}/userHasSeenNotice`;

/**
 * Set opt-in/out status
 * @internal
 */
exports.UserHasSeenNoticeRoute = UserHasSeenNoticeRoute;
const OptInRoute = `${BASE_INTERNAL_PATH}/optIn`;

/**
 * Fetch the Snapshot telemetry report
 * @internal
 */
exports.OptInRoute = OptInRoute;
const FetchSnapshotTelemetry = `${BASE_INTERNAL_PATH}/clusters/_stats`;

/**
 * Get Opt-in stats
 * @internal
 * @deprecated
 */
exports.FetchSnapshotTelemetry = FetchSnapshotTelemetry;
const GetOptInStatsRoutePathBasedV2 = '/api/telemetry/v2/clusters/_opt_in_stats';
exports.GetOptInStatsRoutePathBasedV2 = GetOptInStatsRoutePathBasedV2;