"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricCounterService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _counter = require("./counter");
var _unflatten_object = require("./unflatten_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MetricCounterService {
  constructor(keys, initialNamespace) {
    (0, _defineProperty2.default)(this, "counters", new Map());
    (0, _defineProperty2.default)(this, "keys", void 0);
    if (!keys || !keys.length) {
      throw new Error('Metrics counter service must be initialized with at least one key');
    }
    this.keys = keys;
    this.initializeCountersForNamespace(initialNamespace);
  }
  initialMetrics() {
    return this.toJson(true);
  }
  reset() {
    this.counters.forEach(val => {
      val.reset();
    });
  }
  increment(key, namespace) {
    var _this$counters$get;
    // initialize counters for namespace if necessary
    this.initializeCountersForNamespace(namespace);

    // increment counter in specified namespace
    (_this$counters$get = this.counters.get(this.buildCounterKey(key, namespace))) === null || _this$counters$get === void 0 ? void 0 : _this$counters$get.increment();
  }
  collect() {
    return this.toJson();
  }
  initializeCountersForNamespace(namespace) {
    for (const key of this.keys) {
      const counterKey = this.buildCounterKey(key, namespace);
      if (!this.counters.get(counterKey)) {
        this.counters.set(counterKey, new _counter.Counter());
      }
    }
  }
  buildCounterKey(key, namespace) {
    const prefix = namespace ? `${namespace}.` : '';
    return `${prefix}${key}`;
  }
  toJson(initialMetric = false) {
    const collected = {};
    this.counters.forEach((val, key) => {
      collected[key] = initialMetric ? val.initialCount() : val.get();
    });
    return (0, _unflatten_object.unflattenObject)(collected);
  }
}
exports.MetricCounterService = MetricCounterService;