"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorDetail = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorDetail = (configId, location) => {
  const params = {
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size: 1,
      query: {
        bool: {
          filter: [{
            term: {
              config_id: configId
            }
          }, {
            term: {
              'observer.geo.name': location
            }
          }, {
            exists: {
              field: 'summary'
            }
          }]
        }
      },
      sort: [{
        '@timestamp': 'desc'
      }]
    }
  };
  const {
    data: result,
    loading
  } = (0, _public.useEsSearch)(params, [configId, location], {
    name: 'getMonitorStatusByLocation'
  });
  if (!result || result.hits.hits.length !== 1) return {
    data: undefined,
    loading
  };
  return {
    data: {
      ...result.hits.hits[0]._source,
      timestamp: result.hits.hits[0]._source['@timestamp']
    },
    loading
  };
};
exports.useMonitorDetail = useMonitorDetail;