"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsThemeContext = exports.SyntheticsThemeContextProvider = exports.SyntheticsThemeContext = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireWildcard(require("react"));
var _eui_charts_theme = require("@elastic/eui/dist/eui_charts_theme");
var _charts = require("@elastic/charts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * These are default values for the context. These defaults are typically
 * overwritten by the Synthetics App upon its invocation.
 */
const defaultContext = {
  colors: {
    danger: _uiTheme.euiLightVars.euiColorDanger,
    dangerBehindText: _uiTheme.euiDarkVars.euiColorVis9_behindText,
    mean: _uiTheme.euiLightVars.euiColorPrimary,
    range: _uiTheme.euiLightVars.euiFocusBackgroundColor,
    success: _uiTheme.euiLightVars.euiColorSuccess,
    warning: _uiTheme.euiLightVars.euiColorWarning,
    gray: _uiTheme.euiLightVars.euiColorLightShade,
    lightestShade: _uiTheme.euiLightVars.euiColorLightestShade
  },
  chartTheme: {
    baseTheme: _charts.LIGHT_THEME,
    theme: _eui_charts_theme.EUI_CHARTS_THEME_LIGHT.theme
  }
};
const SyntheticsThemeContext = /*#__PURE__*/(0, _react.createContext)(defaultContext);
exports.SyntheticsThemeContext = SyntheticsThemeContext;
const SyntheticsThemeContextProvider = ({
  darkMode,
  children
}) => {
  let colors;
  if (darkMode) {
    colors = {
      danger: _uiTheme.euiDarkVars.euiColorVis9,
      dangerBehindText: _uiTheme.euiDarkVars.euiColorVis9_behindText,
      mean: _uiTheme.euiDarkVars.euiColorPrimary,
      gray: _uiTheme.euiDarkVars.euiColorLightShade,
      range: _uiTheme.euiDarkVars.euiFocusBackgroundColor,
      success: _uiTheme.euiDarkVars.euiColorSuccess,
      warning: _uiTheme.euiDarkVars.euiColorWarning,
      lightestShade: _uiTheme.euiDarkVars.euiColorLightestShade
    };
  } else {
    colors = {
      danger: _uiTheme.euiLightVars.euiColorVis9,
      dangerBehindText: _uiTheme.euiLightVars.euiColorVis9_behindText,
      mean: _uiTheme.euiLightVars.euiColorPrimary,
      gray: _uiTheme.euiLightVars.euiColorLightShade,
      range: _uiTheme.euiLightVars.euiFocusBackgroundColor,
      success: _uiTheme.euiLightVars.euiColorSuccess,
      warning: _uiTheme.euiLightVars.euiColorWarning,
      lightestShade: _uiTheme.euiLightVars.euiColorLightestShade
    };
  }
  const value = (0, _react.useMemo)(() => {
    return {
      colors,
      chartTheme: {
        baseTheme: darkMode ? _charts.DARK_THEME : _charts.LIGHT_THEME,
        theme: darkMode ? _eui_charts_theme.EUI_CHARTS_THEME_DARK.theme : _eui_charts_theme.EUI_CHARTS_THEME_LIGHT.theme
      }
    };
  }, [colors, darkMode]);
  return /*#__PURE__*/_react.default.createElement(SyntheticsThemeContext.Provider, {
    value: value,
    children: children
  });
};
exports.SyntheticsThemeContextProvider = SyntheticsThemeContextProvider;
const useSyntheticsThemeContext = () => (0, _react.useContext)(SyntheticsThemeContext);
exports.useSyntheticsThemeContext = useSyntheticsThemeContext;