"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrivateLocationsAPI = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _react = require("react");
var _reactRedux = require("react-redux");
var _service_locations = require("../../../../state/service_locations");
var _private_locations = require("../../../../state/private_locations");
var _api = require("../../../../state/private_locations/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePrivateLocationsAPI = () => {
  const [formData, setFormData] = (0, _react.useState)();
  const [deleteId, setDeleteId] = (0, _react.useState)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const setIsAddingNew = val => dispatch((0, _private_locations.setAddingNewPrivateLocation)(val));
  const privateLocations = (0, _reactRedux.useSelector)(_private_locations.selectPrivateLocations);
  const fetchLoading = (0, _reactRedux.useSelector)(_private_locations.selectPrivateLocationsLoading);
  (0, _react.useEffect)(() => {
    dispatch(_private_locations.getPrivateLocationsAction.get());
  }, [dispatch]);
  const {
    loading: saveLoading
  } = (0, _public.useFetcher)(async () => {
    if (formData) {
      const result = await (0, _api.addSyntheticsPrivateLocations)(formData);
      setFormData(undefined);
      setIsAddingNew(false);
      dispatch((0, _service_locations.getServiceLocations)());
      dispatch(_private_locations.getPrivateLocationsAction.get());
      return result;
    }
  }, [formData]);
  const onSubmit = data => {
    setFormData(data);
  };
  const onDelete = id => {
    setDeleteId(id);
  };
  const {
    loading: deleteLoading
  } = (0, _public.useFetcher)(async () => {
    if (deleteId) {
      const result = await (0, _api.deleteSyntheticsPrivateLocations)(deleteId);
      setDeleteId(undefined);
      dispatch((0, _service_locations.getServiceLocations)());
      dispatch(_private_locations.getPrivateLocationsAction.get());
      return result;
    }
  }, [deleteId]);
  return {
    formData,
    onSubmit,
    onDelete,
    deleteLoading: Boolean(deleteLoading),
    loading: Boolean(fetchLoading || saveLoading),
    privateLocations
  };
};
exports.usePrivateLocationsAPI = usePrivateLocationsAPI;