"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataRetentionTab = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _policy_link = require("./policy_link");
var _use_get_ilm_policies = require("./hooks/use_get_ilm_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataRetentionTab = () => {
  var _body;
  const {
    data,
    loading,
    error
  } = (0, _use_get_ilm_policies.useGetIlmPolicies)();
  if (error && ((_body = error.body) === null || _body === void 0 ? void 0 : _body.statusCode) === 403) {
    return /*#__PURE__*/_react.default.createElement(Unprivileged, null);
  }
  const columns = [{
    field: 'label',
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.table.dataset', {
      defaultMessage: 'Dataset'
    })
  }, {
    field: 'currentSize',
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.table.currentSize', {
      defaultMessage: 'Current size'
    })
  }, {
    field: 'retentionPeriod',
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.table.retentionPeriod', {
      defaultMessage: 'Retention period'
    })
  }, {
    field: 'policy.name',
    name: /*#__PURE__*/_react.default.createElement(_policy_link.PolicyNameLabel, null),
    render: (name, _item) => /*#__PURE__*/_react.default.createElement(_policy_link.PolicyLink, {
      name: name
    })
  }];
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: CALLOUT_TITLE,
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.settingsRoute.retentionCalloutDescription",
    defaultMessage: "To change your data retention settings, we recommend creating your own index lifecycle policy and attaching it to the relevant custom Component Template in {stackManagement}. For more information, {docsLink}.",
    values: {
      stackManagement: /*#__PURE__*/_react.default.createElement("strong", null, STACK_MANAGEMENT),
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsDataRetentionTabLink",
        href: "https://www.elastic.co/guide/en/observability/current/synthetics-manage-retention.html"
      }, READ_OUR_DOCS)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: loading,
    tableCaption: RETENTION_TABLE,
    items: data,
    columns: columns,
    tableLayout: "auto"
  }));
};
exports.DataRetentionTab = DataRetentionTab;
const Unprivileged = () => {
  const {
    services: {
      docLinks
    }
  } = (0, _public.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "syntheticsUnprivileged",
    color: "plain",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoObservability",
      size: "xl"
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.dataRetention.unprivileged.unprivilegedTitle",
      defaultMessage: "Missing privileges"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.params.unprivileged.unprivilegedDescription",
      defaultMessage: "You need additional privileges to view Synthetics app data usage and retention settings. {docsLink}",
      values: {
        docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "syntheticsUnprivilegedLearnMoreLink",
          href: docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.synthetics.featureRoles,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.synthetics.monitorManagement.projectDelete.docsLink', {
          defaultMessage: 'Learn more'
        }))
      }
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      css: (0, _react2.css)`
            text-align: initial;
          `,
      children: `\n- ${INDEX_PRIVILEGES} \n- ${CLUSTER_PRIVILEGES}`
    })
  });
};
const INDEX_PRIVILEGES = _i18n.i18n.translate('xpack.synthetics.dataRetention.unprivileged.index', {
  defaultMessage: '`read`, `monitor` on the following Elasticsearch indices: `synthetics-*`'
});
const CLUSTER_PRIVILEGES = _i18n.i18n.translate('xpack.synthetics.dataRetention.unprivileged.cluster', {
  defaultMessage: '`read_ilm`, `monitor` to view and `manage_ilm` to manage ILM policies on the Elasticsearch cluster.'
});
const CALLOUT_TITLE = _i18n.i18n.translate('xpack.synthetics.settingsRoute.retentionCalloutTitle', {
  defaultMessage: 'Synthetics data is configured by managed index lifecycle policies'
});
const STACK_MANAGEMENT = _i18n.i18n.translate('xpack.synthetics.stackManagement', {
  defaultMessage: 'Stack Management'
});
const READ_OUR_DOCS = _i18n.i18n.translate('xpack.synthetics.settingsRoute.readDocs', {
  defaultMessage: 'read our documentation'
});
const RETENTION_TABLE = _i18n.i18n.translate('xpack.synthetics.settingsRoute.tableCaption', {
  defaultMessage: 'Synthetics data retention policies'
});