"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEmail = DefaultEmail;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _validation = require("./validation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DefaultEmail({
  loading,
  onChange,
  value,
  isDisabled,
  selectedConnectors
}) {
  const {
    actionTypeRegistry
  } = (0, _public.useKibana)().services.triggersActionsUi;
  const emailActionType = actionTypeRegistry.get('.email');
  const ActionParams = emailActionType.actionParamsFields;
  const [isTouched, setIsTouched] = (0, _react.useState)(false);
  const errors = (0, _validation.hasInvalidEmail)(selectedConnectors, value, isTouched);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.sourceConfiguration.alertConnectors.defaultEmail",
      defaultMessage: "Default email"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.sourceConfiguration.defaultConnectors.description.defaultEmail",
      defaultMessage: "Email settings required for selected email alert connectors."
    })
  }, /*#__PURE__*/_react.default.createElement(ActionParams, {
    isLoading: loading,
    actionParams: value !== null && value !== void 0 ? value : {},
    errors: errors,
    editAction: (key, val, index) => {
      if (key !== 'message') {
        onChange({
          ...(value !== null && value !== void 0 ? value : {}),
          [key]: val
        });
      }
    },
    showEmailSubjectAndMessage: false,
    index: 1,
    isDisabled: isDisabled,
    onBlur: () => setIsTouched(true)
  }));
}