"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorStatusData = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _schedule_to_time = require("../../../../../../common/lib/schedule_to_time");
var _synthetics_refresh_context = require("../../../contexts/synthetics_refresh_context");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var _use_ping_statuses = require("../hooks/use_ping_statuses");
var _monitor_status_data = require("./monitor_status_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorStatusData = ({
  from,
  to
}) => {
  const {
    lastRefresh
  } = (0, _synthetics_refresh_context.useSyntheticsRefreshContext)();
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const monitorInterval = Math.max(3, monitor !== null && monitor !== void 0 && monitor.schedule ? (0, _schedule_to_time.scheduleToMinutes)(monitor === null || monitor === void 0 ? void 0 : monitor.schedule) : 3);
  const fromMillis = (0, _monitor_status_data.dateToMilli)(from);
  const toMillis = (0, _monitor_status_data.dateToMilli)(to);
  const totalMinutes = Math.ceil(toMillis - fromMillis) / (1000 * 60);
  const pingStatuses = (0, _use_ping_statuses.usePingStatuses)({
    from: fromMillis,
    to: toMillis,
    size: Math.min(10000, Math.ceil(totalMinutes / monitorInterval * 2)),
    // Acts as max size between from - to
    monitorInterval,
    lastRefresh
  });
  const [binsAvailableByWidth, setBinsAvailableByWidth] = (0, _react.useState)(50);
  const intervalByWidth = Math.floor(Math.max(monitorInterval, totalMinutes / binsAvailableByWidth));

  // Disabling deps warning as we wanna throttle the callback
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const handleResize = (0, _react.useCallback)((0, _lodash.throttle)(e => {
    setBinsAvailableByWidth(Math.floor(e.width / _monitor_status_data.CHART_CELL_WIDTH));
  }, 500), []);
  const {
    timeBins,
    timeBinsByEndTime,
    xDomain
  } = (0, _react.useMemo)(() => {
    var _bins$0$end, _bins$, _bins$end, _bins;
    const timeBuckets = (0, _monitor_status_data.createTimeBuckets)(intervalByWidth, fromMillis, toMillis);
    const bins = (0, _monitor_status_data.createStatusTimeBins)(timeBuckets, pingStatuses);
    const indexedBins = (0, _monitor_status_data.indexBinsByEndTime)(bins);
    const timeDomain = {
      min: (_bins$0$end = bins === null || bins === void 0 ? void 0 : (_bins$ = bins[0]) === null || _bins$ === void 0 ? void 0 : _bins$.end) !== null && _bins$0$end !== void 0 ? _bins$0$end : fromMillis,
      max: (_bins$end = bins === null || bins === void 0 ? void 0 : (_bins = bins[bins.length - 1]) === null || _bins === void 0 ? void 0 : _bins.end) !== null && _bins$end !== void 0 ? _bins$end : toMillis
    };
    return {
      timeBins: bins,
      timeBinsByEndTime: indexedBins,
      xDomain: timeDomain
    };
  }, [intervalByWidth, pingStatuses, fromMillis, toMillis]);
  return {
    intervalByWidth,
    timeBins,
    xDomain,
    handleResize,
    getTimeBinByXValue: xValue => xValue === undefined ? undefined : timeBinsByEndTime.get(xValue)
  };
};
exports.useMonitorStatusData = useMonitorStatusData;