"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorLatestPing = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _runtime_types = require("../../../../../../common/runtime_types");
var _contexts = require("../../../contexts");
var _state = require("../../../state");
var _use_selected_location = require("./use_selected_location");
var _use_selected_monitor = require("./use_selected_monitor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorLatestPing = params => {
  var _params$monitorId, _latestPing$observer, _latestPing$observer$;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const location = (0, _use_selected_location.useSelectedLocation)();
  const monitorId = (_params$monitorId = params === null || params === void 0 ? void 0 : params.monitorId) !== null && _params$monitorId !== void 0 ? _params$monitorId : monitor === null || monitor === void 0 ? void 0 : monitor.id;
  const locationLabel = location === null || location === void 0 ? void 0 : location.label;
  const {
    data: latestPing,
    loading,
    loaded
  } = (0, _reactRedux.useSelector)(_state.selectLastRunMetadata);
  const latestPingId = latestPing === null || latestPing === void 0 ? void 0 : latestPing.monitor.id;
  const isIdSame = latestPingId === monitorId || latestPingId === (monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.CUSTOM_HEARTBEAT_ID]);
  const isLocationSame = (latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$observer = latestPing.observer) === null || _latestPing$observer === void 0 ? void 0 : (_latestPing$observer$ = _latestPing$observer.geo) === null || _latestPing$observer$ === void 0 ? void 0 : _latestPing$observer$.name) === locationLabel;
  const isUpToDate = isIdSame && isLocationSame;
  (0, _react.useEffect)(() => {
    if (monitorId && locationLabel) {
      dispatch(_state.getMonitorLastRunAction.get({
        monitorId,
        locationId: locationLabel
      }));
    }
  }, [dispatch, monitorId, locationLabel, isUpToDate, lastRefresh]);
  if (!monitorId || !locationLabel) {
    return {
      loading,
      latestPing: undefined,
      loaded
    };
  }
  if (!latestPing) {
    return {
      loading,
      latestPing: undefined,
      loaded
    };
  }
  if (!isIdSame || !isLocationSame) {
    return {
      loading,
      latestPing: undefined,
      loaded
    };
  }
  return {
    loading,
    latestPing,
    loaded
  };
};
exports.useMonitorLatestPing = useMonitorLatestPing;