"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadOnlyCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReadOnlyCallout = ({
  projectId,
  canUsePublicLocations
}) => {
  if (projectId) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.project.readOnly.callout.title",
        defaultMessage: "This configuration is read-only"
      }),
      iconType: "document"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.project.readOnly.callout.content",
      defaultMessage: "This monitor was added from an external project: {projectId}. From this page, you can only enable and disable the monitor and its alerts, or remove it. To make configuration changes, you have to edit its source file and push it again from that project.",
      values: {
        projectId: /*#__PURE__*/_react.default.createElement("strong", null, projectId)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  if (!canUsePublicLocations) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.publicLocations.readOnly.callout.title",
        defaultMessage: "You do not have permission to use Elastic managed locations"
      }),
      iconType: "alert"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.publicLocations.readOnly.callout.content",
      defaultMessage: "This monitor contains a Elastic managed location. To edit this monitor, you need to have permission to use Elastic managed locations."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  return null;
};
exports.ReadOnlyCallout = ReadOnlyCallout;