"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSimpleMonitor = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _react = require("react");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactRedux = require("react-redux");
var _contexts = require("../../contexts");
var _state = require("../../state");
var _show_sync_errors = require("../monitors_page/management/show_sync_errors");
var _monitor_defaults = require("../../../../../common/constants/monitor_defaults");
var _monitor_management = require("../../../../../common/constants/monitor_management");
var _runtime_types = require("../../../../../common/runtime_types");
var _simple_monitor_form = require("./simple_monitor_form");
var _kibana_service = require("../../../../utils/kibana_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSimpleMonitor = ({
  monitorData
}) => {
  const {
    application
  } = (0, _public2.useKibana)().services;
  const {
    locations: serviceLocations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    refreshApp
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    data,
    loading,
    status
  } = (0, _public.useFetcher)(() => {
    if (!monitorData) {
      return new Promise(resolve => resolve(undefined));
    }
    const {
      urls,
      locations
    } = monitorData;
    return (0, _state.createGettingStartedMonitor)({
      monitor: {
        ..._monitor_defaults.DEFAULT_FIELDS.browser,
        'source.inline.script': `step('Go to ${urls}', async () => {
  await page.goto('${urls}');
});`,
        [_monitor_management.ConfigKey.MONITOR_TYPE]: _runtime_types.MonitorTypeEnum.BROWSER,
        [_monitor_management.ConfigKey.NAME]: urls,
        [_monitor_management.ConfigKey.LOCATIONS]: locations,
        [_monitor_management.ConfigKey.URLS]: urls
      }
    });
  }, [monitorData]);
  (0, _react.useEffect)(() => {
    var _data$attributes$erro;
    const newMonitor = data;
    const hasErrors = data && 'attributes' in data && ((_data$attributes$erro = data.attributes.errors) === null || _data$attributes$erro === void 0 ? void 0 : _data$attributes$erro.length) > 0;
    if (hasErrors && !loading) {
      var _attributes$errors;
      (0, _show_sync_errors.showSyncErrors)((_attributes$errors = data === null || data === void 0 ? void 0 : data.attributes.errors) !== null && _attributes$errors !== void 0 ? _attributes$errors : [], serviceLocations, _kibana_service.kibanaService.toasts);
    }
    if (!loading && status === _public.FETCH_STATUS.FAILURE) {
      _kibana_service.kibanaService.toasts.addDanger({
        title: _simple_monitor_form.MONITOR_FAILURE_LABEL,
        toastLifeTimeMs: 3000
      });
    } else if (!loading && newMonitor !== null && newMonitor !== void 0 && newMonitor.id) {
      _kibana_service.kibanaService.toasts.addSuccess({
        title: _simple_monitor_form.MONITOR_SUCCESS_LABEL,
        toastLifeTimeMs: 3000
      });
      refreshApp();
      dispatch((0, _state.cleanMonitorListState)());
      application === null || application === void 0 ? void 0 : application.navigateToApp('synthetics', {
        path: 'monitors'
      });
    }
  }, [application, data, status, dispatch, loading, refreshApp, serviceLocations]);
  return {
    data: data,
    loading
  };
};
exports.useSimpleMonitor = useSimpleMonitor;