"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageRulesLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _translations = require("../../alerts/hooks/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageRulesLink = () => {
  const {
    observability
  } = (0, _public.useKibana)().services;
  const manageRulesUrl = observability.useRulesLink();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsManageRulesLinkLink",
    color: "text",
    href: manageRulesUrl.href
  }, _translations.ToggleFlyoutTranslations.navigateToAlertingButtonContent);
};
exports.ManageRulesLink = ManageRulesLink;