"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CertRefreshBtn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var labels = _interopRequireWildcard(require("./translations"));
var _contexts = require("../../contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CertRefreshBtn = () => {
  const {
    refreshApp
  } = (0, _react.useContext)(_contexts.SyntheticsRefreshContext);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignItems: 'flex-end'
    },
    grow: false,
    "data-test-subj": "certificatesRefreshButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['xs']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "refresh",
    onClick: () => {
      refreshApp();
    },
    "data-test-subj": "superDatePickerApplyTimeButton"
  }, labels.REFRESH_CERT)), /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['xs']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "refresh",
    onClick: () => {
      refreshApp();
    },
    "data-test-subj": "superDatePickerApplyTimeButton"
  })))));
};
exports.CertRefreshBtn = CertRefreshBtn;