"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useValidChannels = useValidChannels;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _common = require("../../../common");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validChannelIds = async (http, newAuthToken, channelId) => {
  return http.post(`${_common.INTERNAL_BASE_STACK_CONNECTORS_API_PATH}/_slack_api/channels/_valid`, {
    body: JSON.stringify({
      authToken: newAuthToken,
      channelIds: [channelId]
    })
  });
};
function useValidChannels(props) {
  const {
    authToken,
    channelId
  } = props;
  const [channels, setChannels] = (0, _react.useState)([]);
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const channelIdToValidate = channels.some(c => c.id === channelId) ? '' : channelId;
  const queryFn = () => {
    return validChannelIds(http, authToken, channelIdToValidate);
  };
  const onErrorFn = () => {
    toasts.addDanger(i18n.ERROR_VALID_CHANNELS);
  };
  const {
    data,
    isLoading,
    isFetching
  } = (0, _reactQuery.useQuery)({
    queryKey: ['validChannels', authToken, channelIdToValidate],
    queryFn,
    onError: onErrorFn,
    enabled: (authToken || '').length > 0 && (channelIdToValidate || '').length > 0,
    refetchOnWindowFocus: false
  });
  (0, _react.useEffect)(() => {
    var _data$invalidChannels, _data$validChannels;
    if (((_data$invalidChannels = data === null || data === void 0 ? void 0 : data.invalidChannels) !== null && _data$invalidChannels !== void 0 ? _data$invalidChannels : []).length > 0) {
      var _data$invalidChannels2;
      toasts.addDanger(i18n.ERROR_INVALID_CHANNELS((_data$invalidChannels2 = data === null || data === void 0 ? void 0 : data.invalidChannels) !== null && _data$invalidChannels2 !== void 0 ? _data$invalidChannels2 : []));
    }
    if (((_data$validChannels = data === null || data === void 0 ? void 0 : data.validChannels) !== null && _data$validChannels !== void 0 ? _data$validChannels : []).length > 0) {
      setChannels(prevChannels => {
        var _data$validChannels2;
        return prevChannels.concat((_data$validChannels2 = data === null || data === void 0 ? void 0 : data.validChannels) !== null && _data$validChannels2 !== void 0 ? _data$validChannels2 : []);
      });
    }
  }, [data, toasts]);
  const resetChannelsToValidate = (0, _react.useCallback)(channelsToReset => {
    if (channelsToReset.length === 0) {
      setChannels([]);
    } else {
      setChannels(prevChannels => {
        if (prevChannels.length === 0) return channelsToReset;
        return prevChannels.filter(c => channelsToReset.some(cTr => cTr.id === c.id));
      });
    }
  }, []);
  return {
    channels,
    resetChannelsToValidate,
    isLoading: isLoading && isFetching
  };
}