"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEB_API = exports.TOKEN_LABEL = exports.SUCCESS_FETCH_CHANNELS = exports.SELECT_MESSAGE = exports.MESSAGE_REQUIRED = exports.ERROR_VALID_CHANNELS = exports.ERROR_INVALID_CHANNELS = exports.CHANNEL_REQUIRED = exports.ALLOWED_CHANNELS = exports.ACTION_TYPE_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MESSAGE_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.error.requiredSlackMessageText', {
  defaultMessage: 'Message is required.'
});
exports.MESSAGE_REQUIRED = MESSAGE_REQUIRED;
const CHANNEL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.error.requiredSlackChannel', {
  defaultMessage: 'Channel ID is required.'
});
exports.CHANNEL_REQUIRED = CHANNEL_REQUIRED;
const TOKEN_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.tokenTextFieldLabel', {
  defaultMessage: 'API Token'
});
exports.TOKEN_LABEL = TOKEN_LABEL;
const WEB_API = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.webApi', {
  defaultMessage: 'Web API'
});
exports.WEB_API = WEB_API;
const SELECT_MESSAGE = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.selectMessageText', {
  defaultMessage: 'Send messages to Slack channels.'
});
exports.SELECT_MESSAGE = SELECT_MESSAGE;
const ACTION_TYPE_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.connectorTypeTitle', {
  defaultMessage: 'Slack'
});
exports.ACTION_TYPE_TITLE = ACTION_TYPE_TITLE;
const ALLOWED_CHANNELS = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.allowedChannelsLabel', {
  defaultMessage: 'Channel IDs'
});
exports.ALLOWED_CHANNELS = ALLOWED_CHANNELS;
const SUCCESS_FETCH_CHANNELS = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.successFetchChannelsText', {
  defaultMessage: 'Fetch all channels'
});
exports.SUCCESS_FETCH_CHANNELS = SUCCESS_FETCH_CHANNELS;
const ERROR_VALID_CHANNELS = _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.errorValidChannelsText', {
  defaultMessage: 'Cannot valid channels, please check the validity of your token or your channel'
});
exports.ERROR_VALID_CHANNELS = ERROR_VALID_CHANNELS;
const ERROR_INVALID_CHANNELS = invalidChannels => _i18n.i18n.translate('xpack.stackConnectors.components.slack_api.errorInvalidChannelsText', {
  defaultMessage: 'Cannot validate channel ID "{channels}", please check the validity of your token and/or the channel ID',
  values: {
    channels: invalidChannels.join(', ')
  }
});
exports.ERROR_INVALID_CHANNELS = ERROR_INVALID_CHANNELS;