"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = void 0;
var _react = require("react");
var _translations = require("./translations");
var _constants = require("../../../common/slack_api/constants");
var _slack = require("../slack/slack");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const isChannelValid = (channels, channelIds) => {
  if (channels === undefined && !(channelIds !== null && channelIds !== void 0 && channelIds.length) || channelIds === undefined && !(channels !== null && channels !== void 0 && channels.length) || !(channelIds !== null && channelIds !== void 0 && channelIds.length) && !(channels !== null && channels !== void 0 && channels.length)) {
    return false;
  }
  return true;
};
const getConnectorType = () => ({
  id: _constants.SLACK_API_CONNECTOR_ID,
  subtype: _slack.subtype,
  hideInUi: true,
  modalWidth: 675,
  iconClass: 'logoSlack',
  selectMessage: _translations.SELECT_MESSAGE,
  actionTypeTitle: _translations.ACTION_TYPE_TITLE,
  validateParams: async actionParams => {
    const errors = {
      text: new Array(),
      channels: new Array()
    };
    const validationResult = {
      errors
    };
    if (actionParams.subAction === 'postMessage') {
      if (!actionParams.subActionParams.text) {
        errors.text.push(_translations.MESSAGE_REQUIRED);
      }
      if (!isChannelValid(actionParams.subActionParams.channels, actionParams.subActionParams.channelIds)) {
        errors.channels.push(_translations.CHANNEL_REQUIRED);
      }
    }
    return validationResult;
  },
  actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./slack_connectors')))),
  actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./slack_params')))),
  convertParamsBetweenGroups: params => {
    if ('message' in params) {
      return {
        subAction: 'postMessage',
        subActionParams: {
          channels: [],
          text: params.message
        }
      };
    } else if ('subAction' in params) {
      return params;
    }
    return {};
  }
});
exports.getConnectorType = getConnectorType;