"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.providerOptions = exports.openAiSecrets = exports.openAiConfig = exports.azureAiSecrets = exports.azureAiConfig = exports.DEFAULT_URL_AZURE = exports.DEFAULT_URL = exports.DEFAULT_BODY_AZURE = exports.DEFAULT_BODY = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/openai/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_URL = 'https://api.openai.com/v1/chat/completions';
exports.DEFAULT_URL = DEFAULT_URL;
const DEFAULT_URL_AZURE = 'https://{your-resource-name}.openai.azure.com/openai/deployments/{deployment-id}/chat/completions?api-version={api-version}';
exports.DEFAULT_URL_AZURE = DEFAULT_URL_AZURE;
const DEFAULT_BODY = `{
    "messages": [{
        "role":"user",
        "content":"Hello world"
    }]
}`;
exports.DEFAULT_BODY = DEFAULT_BODY;
const DEFAULT_BODY_AZURE = `{
    "messages": [{
        "role":"user",
        "content":"Hello world"
    }]
}`;
exports.DEFAULT_BODY_AZURE = DEFAULT_BODY_AZURE;
const openAiConfig = [{
  id: 'apiUrl',
  label: i18n.API_URL_LABEL,
  isUrlField: true,
  defaultValue: DEFAULT_URL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The OpenAI API endpoint URL. For more information on the URL, refer to the {genAiAPIUrlDocs}.",
    id: "xpack.stackConnectors.components.genAi.openAiDocumentation",
    values: {
      genAiAPIUrlDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "open-ai-api-doc",
        href: "https://platform.openai.com/docs/api-reference",
        target: "_blank"
      }, `${i18n.OPENAI} ${i18n.DOCUMENTATION}`)
    }
  })
}, {
  id: 'defaultModel',
  label: i18n.DEFAULT_MODEL_LABEL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "If a request does not include a model, it uses the default.",
    id: "xpack.stackConnectors.components.genAi.openAiDocumentationModel"
  }),
  defaultValue: _constants.DEFAULT_OPENAI_MODEL
}];
exports.openAiConfig = openAiConfig;
const azureAiConfig = [{
  id: 'apiUrl',
  label: i18n.API_URL_LABEL,
  isUrlField: true,
  defaultValue: DEFAULT_URL_AZURE,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Azure OpenAI API endpoint URL. For more information on the URL, refer to the {genAiAPIUrlDocs}.",
    id: "xpack.stackConnectors.components.genAi.azureAiDocumentation",
    values: {
      genAiAPIUrlDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "azure-ai-api-doc",
        href: "https://learn.microsoft.com/en-us/azure/cognitive-services/openai/reference",
        target: "_blank"
      }, `${i18n.AZURE_AI} ${i18n.DOCUMENTATION}`)
    }
  })
}];
exports.azureAiConfig = azureAiConfig;
const openAiSecrets = [{
  id: 'apiKey',
  label: i18n.API_KEY_LABEL,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The OpenAI API authentication key for HTTP Basic authentication. For more details about generating OpenAI API keys, refer to the {genAiAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.genAi.openAiApiKeyDocumentation",
    values: {
      genAiAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "open-ai-api-keys-doc",
        href: "https://platform.openai.com/account/api-keys",
        target: "_blank"
      }, `${i18n.OPENAI} ${i18n.DOCUMENTATION}`)
    }
  })
}];
exports.openAiSecrets = openAiSecrets;
const azureAiSecrets = [{
  id: 'apiKey',
  label: i18n.API_KEY_LABEL,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Azure API key for HTTP Basic authentication. For more details about generating Azure OpenAI API keys, refer to the {genAiAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.genAi.azureAiApiKeyDocumentation",
    values: {
      genAiAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "azure-ai-api-keys-doc",
        href: "https://learn.microsoft.com/en-us/azure/cognitive-services/openai/reference#authentication",
        target: "_blank"
      }, `${i18n.AZURE_AI} ${i18n.DOCUMENTATION}`)
    }
  })
}];
exports.azureAiSecrets = azureAiSecrets;
const providerOptions = [{
  value: _constants.OpenAiProviderType.OpenAi,
  text: i18n.OPENAI,
  label: i18n.OPENAI
}, {
  value: _constants.OpenAiProviderType.AzureAi,
  text: i18n.AZURE_AI,
  label: i18n.AZURE_AI
}];
exports.providerOptions = providerOptions;