"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VISIT_SN_STORE = exports.USER_IDENTIFIER_REQUIRED = exports.USER_IDENTIFIER_LABEL = exports.USERNAME_REQUIRED = exports.USERNAME_LABEL = exports.URGENCY_LABEL = exports.UPDATE_SUCCESS_TOAST_TITLE = exports.UPDATE_SUCCESS_TOAST_TEXT = exports.UNKNOWN = exports.TYPE = exports.TITLE_REQUIRED = exports.SUBCATEGORY_LABEL = exports.SOURCE = exports.SN_INSTANCE_LABEL = exports.SHORT_DESCRIPTION_LABEL = exports.SEVERITY_REQUIRED = exports.SEVERITY_LABEL = exports.SETUP_DEV_INSTANCE = exports.SECURITY_INCIDENT = exports.RESOURCE = exports.REQUIRED_LABEL = exports.PRIVATE_KEY_REQUIRED = exports.PRIVATE_KEY_PASSWORD_LABEL = exports.PRIVATE_KEY_PASSWORD_HELPER_TEXT = exports.PRIVATE_KEY_LABEL = exports.PRIORITY_LABEL = exports.PASSWORD_REQUIRED = exports.PASSWORD_LABEL = exports.OPTIONAL_LABEL = exports.NODE = exports.METRIC_NAME = exports.MESSAGE_KEY = exports.KEY_ID_LABEL = exports.KEYID_REQUIRED = exports.IS_OAUTH = exports.INSTALLATION_CALLOUT_TITLE = exports.INCIDENT = exports.IMPACT_LABEL = exports.FETCH_ERROR = exports.EVENT_CLASS = exports.EVENT = exports.DESCRIPTION_LABEL = exports.CORRELATION_ID_REQUIRED = exports.CORRELATION_ID = exports.CORRELATION_DISPLAY = exports.COMMENTS_LABEL = exports.CLIENTSECRET_REQUIRED = exports.CLIENTSECRET_LABEL = exports.CLIENTID_REQUIRED = exports.CLIENTID_LABEL = exports.CHOICES_API_ERROR = exports.CATEGORY_LABEL = exports.AUTHENTICATION_LABEL = exports.API_URL_LABEL = exports.API_URL_INVALID = exports.API_INFO_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.apiUrlTextFieldLabel', {
  defaultMessage: 'ServiceNow instance URL'
});
exports.API_URL_LABEL = API_URL_LABEL;
const API_URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.invalidApiUrlTextField', {
  defaultMessage: 'URL is invalid.'
});
exports.API_URL_INVALID = API_URL_INVALID;
const AUTHENTICATION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.authenticationLabel', {
  defaultMessage: 'Authentication'
});
exports.AUTHENTICATION_LABEL = AUTHENTICATION_LABEL;
const USERNAME_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.usernameTextFieldLabel', {
  defaultMessage: 'Username'
});
exports.USERNAME_LABEL = USERNAME_LABEL;
const USERNAME_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredUsernameTextField', {
  defaultMessage: 'Username is required.'
});
exports.USERNAME_REQUIRED = USERNAME_REQUIRED;
const PASSWORD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.passwordTextFieldLabel', {
  defaultMessage: 'Password'
});
exports.PASSWORD_LABEL = PASSWORD_LABEL;
const TITLE_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredShortDescTextField', {
  defaultMessage: 'Short description is required.'
});
exports.TITLE_REQUIRED = TITLE_REQUIRED;
const CORRELATION_ID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredCorrelationIdTextField', {
  defaultMessage: 'Correlation id is required.'
});
exports.CORRELATION_ID_REQUIRED = CORRELATION_ID_REQUIRED;
const INCIDENT = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.title', {
  defaultMessage: 'Incident'
});
exports.INCIDENT = INCIDENT;
const SECURITY_INCIDENT = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowSIR.title', {
  defaultMessage: 'Security incident'
});
exports.SECURITY_INCIDENT = SECURITY_INCIDENT;
const SHORT_DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.titleFieldLabel', {
  defaultMessage: 'Short description (required)'
});
exports.SHORT_DESCRIPTION_LABEL = SHORT_DESCRIPTION_LABEL;
const DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.descriptionTextAreaFieldLabel', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION_LABEL = DESCRIPTION_LABEL;
const COMMENTS_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.commentsTextAreaFieldLabel', {
  defaultMessage: 'Additional comments'
});
exports.COMMENTS_LABEL = COMMENTS_LABEL;
const CHOICES_API_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.unableToGetChoicesMessage', {
  defaultMessage: 'Unable to get choices'
});
exports.CHOICES_API_ERROR = CHOICES_API_ERROR;
const CATEGORY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.categoryTitle', {
  defaultMessage: 'Category'
});
exports.CATEGORY_LABEL = CATEGORY_LABEL;
const SUBCATEGORY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.subcategoryTitle', {
  defaultMessage: 'Subcategory'
});
exports.SUBCATEGORY_LABEL = SUBCATEGORY_LABEL;
const URGENCY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.urgencySelectFieldLabel', {
  defaultMessage: 'Urgency'
});
exports.URGENCY_LABEL = URGENCY_LABEL;
const SEVERITY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.severitySelectFieldLabel', {
  defaultMessage: 'Severity'
});
exports.SEVERITY_LABEL = SEVERITY_LABEL;
const IMPACT_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.impactSelectFieldLabel', {
  defaultMessage: 'Impact'
});
exports.IMPACT_LABEL = IMPACT_LABEL;
const PRIORITY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.prioritySelectFieldLabel', {
  defaultMessage: 'Priority'
});
exports.PRIORITY_LABEL = PRIORITY_LABEL;
const API_INFO_ERROR = status => _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.apiInfoError', {
  values: {
    status
  },
  defaultMessage: 'Received status: {status} when attempting to get application information'
});
exports.API_INFO_ERROR = API_INFO_ERROR;
const FETCH_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.fetchErrorMsg', {
  defaultMessage: 'Failed to fetch. Check the URL or the CORS configuration of your ServiceNow instance.'
});
exports.FETCH_ERROR = FETCH_ERROR;
const INSTALLATION_CALLOUT_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.installationCalloutTitle', {
  defaultMessage: 'To use this connector, first install the Elastic app from the ServiceNow app store.'
});
exports.INSTALLATION_CALLOUT_TITLE = INSTALLATION_CALLOUT_TITLE;
const UPDATE_SUCCESS_TOAST_TITLE = connectorName => _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateSuccessToastTitle', {
  defaultMessage: '{connectorName} connector updated',
  values: {
    connectorName
  }
});
exports.UPDATE_SUCCESS_TOAST_TITLE = UPDATE_SUCCESS_TOAST_TITLE;
const UPDATE_SUCCESS_TOAST_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateCalloutText', {
  defaultMessage: 'Connector has been updated.'
});
exports.UPDATE_SUCCESS_TOAST_TEXT = UPDATE_SUCCESS_TOAST_TEXT;
const VISIT_SN_STORE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.visitSNStore', {
  defaultMessage: 'Visit ServiceNow app store'
});
exports.VISIT_SN_STORE = VISIT_SN_STORE;
const SETUP_DEV_INSTANCE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.setupDevInstance', {
  defaultMessage: 'setup a developer instance'
});
exports.SETUP_DEV_INSTANCE = SETUP_DEV_INSTANCE;
const SN_INSTANCE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.snInstanceLabel', {
  defaultMessage: 'ServiceNow instance'
});
exports.SN_INSTANCE_LABEL = SN_INSTANCE_LABEL;
const UNKNOWN = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.unknown', {
  defaultMessage: 'UNKNOWN'
});
exports.UNKNOWN = UNKNOWN;
const CORRELATION_ID = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.correlationID', {
  defaultMessage: 'Correlation ID (optional)'
});
exports.CORRELATION_ID = CORRELATION_ID;
const CORRELATION_DISPLAY = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.correlationDisplay', {
  defaultMessage: 'Correlation display (optional)'
});
exports.CORRELATION_DISPLAY = CORRELATION_DISPLAY;
const EVENT = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowITOM.event', {
  defaultMessage: 'Event'
});

/**
 * ITOM
 */
exports.EVENT = EVENT;
const SOURCE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.sourceTextAreaFieldLabel', {
  defaultMessage: 'Source'
});
exports.SOURCE = SOURCE;
const EVENT_CLASS = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.eventClassTextAreaFieldLabel', {
  defaultMessage: 'Source instance'
});
exports.EVENT_CLASS = EVENT_CLASS;
const RESOURCE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.resourceTextAreaFieldLabel', {
  defaultMessage: 'Resource'
});
exports.RESOURCE = RESOURCE;
const NODE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.nodeTextAreaFieldLabel', {
  defaultMessage: 'Node'
});
exports.NODE = NODE;
const METRIC_NAME = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.metricNameTextAreaFieldLabel', {
  defaultMessage: 'Metric name'
});
exports.METRIC_NAME = METRIC_NAME;
const TYPE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.typeTextAreaFieldLabel', {
  defaultMessage: 'Type'
});
exports.TYPE = TYPE;
const MESSAGE_KEY = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.messageKeyTextAreaFieldLabel', {
  defaultMessage: 'Message key'
});
exports.MESSAGE_KEY = MESSAGE_KEY;
const SEVERITY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredSeverityTextField', {
  defaultMessage: 'Severity is required.'
});
exports.SEVERITY_REQUIRED = SEVERITY_REQUIRED;
const CLIENTID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.clientIdTextFieldLabel', {
  defaultMessage: 'Client ID'
});
exports.CLIENTID_LABEL = CLIENTID_LABEL;
const CLIENTSECRET_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.clientSecretTextFieldLabel', {
  defaultMessage: 'Client secret'
});
exports.CLIENTSECRET_LABEL = CLIENTSECRET_LABEL;
const KEY_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.keyIdTextFieldLabel', {
  defaultMessage: 'JWT verifier key ID'
});
exports.KEY_ID_LABEL = KEY_ID_LABEL;
const USER_IDENTIFIER_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.userEmailTextFieldLabel', {
  defaultMessage: 'User identifier'
});
exports.USER_IDENTIFIER_LABEL = USER_IDENTIFIER_LABEL;
const PRIVATE_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.privateKeyTextFieldLabel', {
  defaultMessage: 'Private key'
});
exports.PRIVATE_KEY_LABEL = PRIVATE_KEY_LABEL;
const PRIVATE_KEY_PASSWORD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.privateKeyPassTextFieldLabel', {
  defaultMessage: 'Private key password'
});
exports.PRIVATE_KEY_PASSWORD_LABEL = PRIVATE_KEY_PASSWORD_LABEL;
const PRIVATE_KEY_PASSWORD_HELPER_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.privateKeyPassLabelHelpText', {
  defaultMessage: 'This is only required if you have set a password on your private key'
});
exports.PRIVATE_KEY_PASSWORD_HELPER_TEXT = PRIVATE_KEY_PASSWORD_HELPER_TEXT;
const CLIENTID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredClientIdTextField', {
  defaultMessage: 'Client ID is required.'
});
exports.CLIENTID_REQUIRED = CLIENTID_REQUIRED;
const PRIVATE_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredPrivateKeyTextField', {
  defaultMessage: 'Private key is required.'
});
exports.PRIVATE_KEY_REQUIRED = PRIVATE_KEY_REQUIRED;
const KEYID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredKeyIdTextField', {
  defaultMessage: 'JWT verifier key ID is required.'
});
exports.KEYID_REQUIRED = KEYID_REQUIRED;
const USER_IDENTIFIER_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredUserIdentifierTextField', {
  defaultMessage: 'User identifier is required.'
});
exports.USER_IDENTIFIER_REQUIRED = USER_IDENTIFIER_REQUIRED;
const PASSWORD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredPasswordTextField', {
  defaultMessage: 'Password is required.'
});
exports.PASSWORD_REQUIRED = PASSWORD_REQUIRED;
const CLIENTSECRET_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredClientSecretTextField', {
  defaultMessage: 'Client secret is required.'
});
exports.CLIENTSECRET_REQUIRED = CLIENTSECRET_REQUIRED;
const IS_OAUTH = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.useOAuth', {
  defaultMessage: 'Use OAuth authentication'
});
exports.IS_OAUTH = IS_OAUTH;
const OPTIONAL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.optionalLabel', {
  defaultMessage: 'Optional'
});
exports.OPTIONAL_LABEL = OPTIONAL_LABEL;
const REQUIRED_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.requiredLabel', {
  defaultMessage: 'Required'
});
exports.REQUIRED_LABEL = REQUIRED_LABEL;