"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SentinelOneSecretsSchema = exports.SentinelOneReleaseHostSchema = exports.SentinelOneKillProcessSchema = exports.SentinelOneKillProcessResponseSchema = exports.SentinelOneKillProcessParamsSchema = exports.SentinelOneIsolateHostSchema = exports.SentinelOneIsolateHostResponseSchema = exports.SentinelOneIsolateHostParamsSchema = exports.SentinelOneGetRemoteScriptsStatusParams = exports.SentinelOneGetRemoteScriptsResponseSchema = exports.SentinelOneGetRemoteScriptsParamsSchema = exports.SentinelOneGetRemoteScriptStatusResponseSchema = exports.SentinelOneGetRemoteScriptStatusParamsSchema = exports.SentinelOneGetAgentsResponseSchema = exports.SentinelOneGetAgentsParamsSchema = exports.SentinelOneExecuteScriptSchema = exports.SentinelOneExecuteScriptResponseSchema = exports.SentinelOneExecuteScriptParamsSchema = exports.SentinelOneConfigSchema = exports.SentinelOneBaseFilterSchema = exports.SentinelOneBaseApiResponseSchema = exports.SentinelOneActionParamsSchema = exports.AlertIds = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/naming-convention */

// Connector schema
const SentinelOneConfigSchema = _configSchema.schema.object({
  url: _configSchema.schema.string()
});
exports.SentinelOneConfigSchema = SentinelOneConfigSchema;
const SentinelOneSecretsSchema = _configSchema.schema.object({
  token: _configSchema.schema.string()
});
exports.SentinelOneSecretsSchema = SentinelOneSecretsSchema;
const SentinelOneBaseApiResponseSchema = _configSchema.schema.object({}, {
  unknowns: 'allow'
});
exports.SentinelOneBaseApiResponseSchema = SentinelOneBaseApiResponseSchema;
const SentinelOneGetAgentsResponseSchema = _configSchema.schema.object({
  pagination: _configSchema.schema.object({
    totalItems: _configSchema.schema.number(),
    nextCursor: _configSchema.schema.nullable(_configSchema.schema.string())
  }),
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  data: _configSchema.schema.arrayOf(_configSchema.schema.object({
    modelName: _configSchema.schema.string(),
    firewallEnabled: _configSchema.schema.boolean(),
    totalMemory: _configSchema.schema.number(),
    osName: _configSchema.schema.string(),
    cloudProviders: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
    siteName: _configSchema.schema.string(),
    cpuId: _configSchema.schema.string(),
    isPendingUninstall: _configSchema.schema.boolean(),
    isUpToDate: _configSchema.schema.boolean(),
    osArch: _configSchema.schema.string(),
    accountId: _configSchema.schema.string(),
    locationEnabled: _configSchema.schema.boolean(),
    consoleMigrationStatus: _configSchema.schema.string(),
    scanFinishedAt: _configSchema.schema.nullable(_configSchema.schema.string()),
    operationalStateExpiration: _configSchema.schema.nullable(_configSchema.schema.string()),
    agentVersion: _configSchema.schema.string(),
    isActive: _configSchema.schema.boolean(),
    locationType: _configSchema.schema.string(),
    activeThreats: _configSchema.schema.number(),
    inRemoteShellSession: _configSchema.schema.boolean(),
    allowRemoteShell: _configSchema.schema.boolean(),
    serialNumber: _configSchema.schema.nullable(_configSchema.schema.string()),
    updatedAt: _configSchema.schema.string(),
    lastActiveDate: _configSchema.schema.string(),
    firstFullModeTime: _configSchema.schema.nullable(_configSchema.schema.string()),
    operationalState: _configSchema.schema.string(),
    externalId: _configSchema.schema.string(),
    mitigationModeSuspicious: _configSchema.schema.string(),
    licenseKey: _configSchema.schema.string(),
    cpuCount: _configSchema.schema.number(),
    mitigationMode: _configSchema.schema.string(),
    networkStatus: _configSchema.schema.string(),
    installerType: _configSchema.schema.string(),
    uuid: _configSchema.schema.string(),
    detectionState: _configSchema.schema.nullable(_configSchema.schema.string()),
    infected: _configSchema.schema.boolean(),
    registeredAt: _configSchema.schema.string(),
    lastIpToMgmt: _configSchema.schema.string(),
    storageName: _configSchema.schema.nullable(_configSchema.schema.string()),
    osUsername: _configSchema.schema.string(),
    groupIp: _configSchema.schema.string(),
    createdAt: _configSchema.schema.string(),
    remoteProfilingState: _configSchema.schema.string(),
    groupUpdatedAt: _configSchema.schema.nullable(_configSchema.schema.string()),
    scanAbortedAt: _configSchema.schema.nullable(_configSchema.schema.string()),
    isUninstalled: _configSchema.schema.boolean(),
    networkQuarantineEnabled: _configSchema.schema.boolean(),
    tags: _configSchema.schema.object({
      sentinelone: _configSchema.schema.arrayOf(_configSchema.schema.object({
        assignedBy: _configSchema.schema.string(),
        assignedAt: _configSchema.schema.string(),
        assignedById: _configSchema.schema.string(),
        key: _configSchema.schema.string(),
        value: _configSchema.schema.string(),
        id: _configSchema.schema.string()
      }))
    }),
    externalIp: _configSchema.schema.string(),
    siteId: _configSchema.schema.string(),
    machineType: _configSchema.schema.string(),
    domain: _configSchema.schema.string(),
    scanStatus: _configSchema.schema.string(),
    osStartTime: _configSchema.schema.string(),
    accountName: _configSchema.schema.string(),
    lastLoggedInUserName: _configSchema.schema.string(),
    showAlertIcon: _configSchema.schema.boolean(),
    rangerStatus: _configSchema.schema.string(),
    groupName: _configSchema.schema.string(),
    threatRebootRequired: _configSchema.schema.boolean(),
    remoteProfilingStateExpiration: _configSchema.schema.nullable(_configSchema.schema.string()),
    policyUpdatedAt: _configSchema.schema.nullable(_configSchema.schema.string()),
    activeDirectory: _configSchema.schema.object({
      userPrincipalName: _configSchema.schema.nullable(_configSchema.schema.string()),
      lastUserDistinguishedName: _configSchema.schema.nullable(_configSchema.schema.string()),
      computerMemberOf: _configSchema.schema.arrayOf(_configSchema.schema.object({
        type: _configSchema.schema.string()
      })),
      lastUserMemberOf: _configSchema.schema.arrayOf(_configSchema.schema.object({
        type: _configSchema.schema.string()
      })),
      mail: _configSchema.schema.nullable(_configSchema.schema.string()),
      computerDistinguishedName: _configSchema.schema.nullable(_configSchema.schema.string())
    }),
    isDecommissioned: _configSchema.schema.boolean(),
    rangerVersion: _configSchema.schema.string(),
    userActionsNeeded: _configSchema.schema.arrayOf(_configSchema.schema.object({
      type: _configSchema.schema.string(),
      example: _configSchema.schema.string(),
      enum: _configSchema.schema.arrayOf(_configSchema.schema.string())
    })),
    locations: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({
      name: _configSchema.schema.string(),
      scope: _configSchema.schema.string(),
      id: _configSchema.schema.string()
    }))),
    id: _configSchema.schema.string(),
    coreCount: _configSchema.schema.number(),
    osRevision: _configSchema.schema.string(),
    osType: _configSchema.schema.string(),
    groupId: _configSchema.schema.string(),
    computerName: _configSchema.schema.string(),
    scanStartedAt: _configSchema.schema.string(),
    encryptedApplications: _configSchema.schema.boolean(),
    storageType: _configSchema.schema.nullable(_configSchema.schema.string()),
    networkInterfaces: _configSchema.schema.arrayOf(_configSchema.schema.object({
      gatewayMacAddress: _configSchema.schema.nullable(_configSchema.schema.string()),
      inet6: _configSchema.schema.arrayOf(_configSchema.schema.string()),
      name: _configSchema.schema.string(),
      inet: _configSchema.schema.arrayOf(_configSchema.schema.string()),
      physical: _configSchema.schema.string(),
      gatewayIp: _configSchema.schema.nullable(_configSchema.schema.string()),
      id: _configSchema.schema.string()
    })),
    fullDiskScanLastUpdatedAt: _configSchema.schema.string(),
    appsVulnerabilityStatus: _configSchema.schema.string()
  }, {
    unknowns: 'allow'
  }))
});
exports.SentinelOneGetAgentsResponseSchema = SentinelOneGetAgentsResponseSchema;
const SentinelOneIsolateHostResponseSchema = _configSchema.schema.object({
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  data: _configSchema.schema.object({
    affected: _configSchema.schema.number()
  }, {
    unknowns: 'allow'
  })
});
exports.SentinelOneIsolateHostResponseSchema = SentinelOneIsolateHostResponseSchema;
const SentinelOneGetRemoteScriptsParamsSchema = _configSchema.schema.object({
  query: _configSchema.schema.nullable(_configSchema.schema.string()),
  osTypes: _configSchema.schema.nullable(_configSchema.schema.string())
});
exports.SentinelOneGetRemoteScriptsParamsSchema = SentinelOneGetRemoteScriptsParamsSchema;
const AlertIds = _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()));
exports.AlertIds = AlertIds;
const SentinelOneGetRemoteScriptsResponseSchema = _configSchema.schema.object({
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  pagination: _configSchema.schema.object({
    nextCursor: _configSchema.schema.nullable(_configSchema.schema.string()),
    totalItems: _configSchema.schema.number()
  }),
  data: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    updater: _configSchema.schema.nullable(_configSchema.schema.string()),
    isAvailableForLite: _configSchema.schema.boolean(),
    isAvailableForArs: _configSchema.schema.boolean(),
    fileSize: _configSchema.schema.number(),
    mgmtId: _configSchema.schema.number(),
    scopeLevel: _configSchema.schema.string(),
    shortFileName: _configSchema.schema.string(),
    scriptName: _configSchema.schema.string(),
    creator: _configSchema.schema.string(),
    package: _configSchema.schema.nullable(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      bucketName: _configSchema.schema.string(),
      endpointExpiration: _configSchema.schema.string(),
      fileName: _configSchema.schema.string(),
      endpointExpirationSeconds: _configSchema.schema.nullable(_configSchema.schema.number()),
      fileSize: _configSchema.schema.number(),
      signatureType: _configSchema.schema.string(),
      signature: _configSchema.schema.string()
    })),
    bucketName: _configSchema.schema.string(),
    inputRequired: _configSchema.schema.boolean(),
    fileName: _configSchema.schema.string(),
    supportedDestinations: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    scopeName: _configSchema.schema.nullable(_configSchema.schema.string()),
    signatureType: _configSchema.schema.string(),
    outputFilePaths: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    scriptDescription: _configSchema.schema.nullable(_configSchema.schema.string()),
    createdByUserId: _configSchema.schema.string(),
    scopeId: _configSchema.schema.string(),
    updatedAt: _configSchema.schema.string(),
    scriptType: _configSchema.schema.string(),
    scopePath: _configSchema.schema.string(),
    creatorId: _configSchema.schema.string(),
    osTypes: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    scriptRuntimeTimeoutSeconds: _configSchema.schema.number(),
    version: _configSchema.schema.string(),
    updaterId: _configSchema.schema.nullable(_configSchema.schema.string()),
    createdAt: _configSchema.schema.string(),
    inputExample: _configSchema.schema.nullable(_configSchema.schema.string()),
    inputInstructions: _configSchema.schema.nullable(_configSchema.schema.string()),
    signature: _configSchema.schema.string(),
    createdByUser: _configSchema.schema.string(),
    requiresApproval: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }))
});
exports.SentinelOneGetRemoteScriptsResponseSchema = SentinelOneGetRemoteScriptsResponseSchema;
const SentinelOneExecuteScriptParamsSchema = _configSchema.schema.object({
  computerName: _configSchema.schema.maybe(_configSchema.schema.string()),
  script: _configSchema.schema.object({
    scriptId: _configSchema.schema.string(),
    scriptName: _configSchema.schema.maybe(_configSchema.schema.string()),
    apiKey: _configSchema.schema.maybe(_configSchema.schema.string()),
    outputDirectory: _configSchema.schema.maybe(_configSchema.schema.string()),
    requiresApproval: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    taskDescription: _configSchema.schema.maybe(_configSchema.schema.string()),
    singularityxdrUrl: _configSchema.schema.maybe(_configSchema.schema.string()),
    inputParams: _configSchema.schema.maybe(_configSchema.schema.string()),
    singularityxdrKeyword: _configSchema.schema.maybe(_configSchema.schema.string()),
    scriptRuntimeTimeoutSeconds: _configSchema.schema.maybe(_configSchema.schema.number()),
    passwordFromScope: _configSchema.schema.maybe(_configSchema.schema.object({
      scopeLevel: _configSchema.schema.maybe(_configSchema.schema.string()),
      scopeId: _configSchema.schema.maybe(_configSchema.schema.string())
    })),
    password: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  alertIds: AlertIds
});
exports.SentinelOneExecuteScriptParamsSchema = SentinelOneExecuteScriptParamsSchema;
const SentinelOneGetRemoteScriptStatusParamsSchema = _configSchema.schema.object({
  parentTaskId: _configSchema.schema.string()
}, {
  unknowns: 'allow'
});
exports.SentinelOneGetRemoteScriptStatusParamsSchema = SentinelOneGetRemoteScriptStatusParamsSchema;
const SentinelOneGetRemoteScriptStatusResponseSchema = _configSchema.schema.object({
  pagination: _configSchema.schema.object({
    totalItems: _configSchema.schema.number(),
    nextCursor: _configSchema.schema.nullable(_configSchema.schema.string())
  }),
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string()
  }))),
  data: _configSchema.schema.arrayOf(_configSchema.schema.object({
    agentIsDecommissioned: _configSchema.schema.nullable(_configSchema.schema.boolean()),
    agentComputerName: _configSchema.schema.nullable(_configSchema.schema.string()),
    status: _configSchema.schema.nullable(_configSchema.schema.string()),
    groupName: _configSchema.schema.nullable(_configSchema.schema.string()),
    initiatedById: _configSchema.schema.nullable(_configSchema.schema.string()),
    parentTaskId: _configSchema.schema.nullable(_configSchema.schema.string()),
    updatedAt: _configSchema.schema.nullable(_configSchema.schema.string()),
    createdAt: _configSchema.schema.nullable(_configSchema.schema.string()),
    agentIsActive: _configSchema.schema.nullable(_configSchema.schema.boolean()),
    agentOsType: _configSchema.schema.nullable(_configSchema.schema.string()),
    agentMachineType: _configSchema.schema.nullable(_configSchema.schema.string()),
    id: _configSchema.schema.nullable(_configSchema.schema.string()),
    siteName: _configSchema.schema.nullable(_configSchema.schema.string()),
    detailedStatus: _configSchema.schema.nullable(_configSchema.schema.string()),
    siteId: _configSchema.schema.nullable(_configSchema.schema.string()),
    scriptResultsSignature: _configSchema.schema.nullable(_configSchema.schema.nullable(_configSchema.schema.string())),
    initiatedBy: _configSchema.schema.nullable(_configSchema.schema.string()),
    accountName: _configSchema.schema.nullable(_configSchema.schema.string()),
    groupId: _configSchema.schema.nullable(_configSchema.schema.string()),
    agentUuid: _configSchema.schema.nullable(_configSchema.schema.string()),
    accountId: _configSchema.schema.nullable(_configSchema.schema.string()),
    type: _configSchema.schema.nullable(_configSchema.schema.string()),
    scriptResultsPath: _configSchema.schema.nullable(_configSchema.schema.string()),
    scriptResultsBucket: _configSchema.schema.nullable(_configSchema.schema.string()),
    description: _configSchema.schema.nullable(_configSchema.schema.string()),
    agentId: _configSchema.schema.nullable(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  }))
});
exports.SentinelOneGetRemoteScriptStatusResponseSchema = SentinelOneGetRemoteScriptStatusResponseSchema;
const SentinelOneBaseFilterSchema = _configSchema.schema.object({
  K8SNodeName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  coreCount__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  rangerStatuses: _configSchema.schema.nullable(_configSchema.schema.string()),
  adUserQuery__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  rangerVersionsNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  rangerStatusesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  coreCount__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatCreatedAt__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  decommissionedAt__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  operationalStatesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  appsVulnerabilityStatusesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  mitigationMode: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  gatewayIp: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudImage__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  registeredAt__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatMitigationStatus: _configSchema.schema.nullable(_configSchema.schema.string()),
  installerTypesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  appsVulnerabilityStatuses: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatResolved: _configSchema.schema.nullable(_configSchema.schema.string()),
  mitigationModeSuspicious: _configSchema.schema.nullable(_configSchema.schema.string()),
  isUpToDate: _configSchema.schema.nullable(_configSchema.schema.string()),
  adComputerQuery__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  azureResourceGroup__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  scanStatus: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatContentHash: _configSchema.schema.nullable(_configSchema.schema.string()),
  osTypesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatRebootRequired: _configSchema.schema.nullable(_configSchema.schema.string()),
  totalMemory__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  firewallEnabled: _configSchema.schema.nullable(_configSchema.schema.string()),
  gcpServiceAccount__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  remoteProfilingStates: _configSchema.schema.nullable(_configSchema.schema.string()),
  filteredGroupIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  agentVersions: _configSchema.schema.nullable(_configSchema.schema.string()),
  activeThreats: _configSchema.schema.nullable(_configSchema.schema.string()),
  machineTypesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastActiveDate__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  awsSubnetIds__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  installerTypes: _configSchema.schema.nullable(_configSchema.schema.string()),
  registeredAt__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  migrationStatus: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudTags__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  totalMemory__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  decommissionedAt__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatCreatedAt__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  osArch: _configSchema.schema.nullable(_configSchema.schema.string()),
  registeredAt__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  registeredAt__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  siteIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkInterfaceInet__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  groupIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  uuids: _configSchema.schema.nullable(_configSchema.schema.string()),
  accountIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  scanStatusesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  cpuCount__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  locationIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  awsSecurityGroups__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkStatusesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  activeThreats__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  infected: _configSchema.schema.nullable(_configSchema.schema.string()),
  osVersion__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  machineTypes: _configSchema.schema.nullable(_configSchema.schema.string()),
  agentPodName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  computerName__like: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatCreatedAt__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  consoleMigrationStatusesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  computerName: _configSchema.schema.nullable(_configSchema.schema.string()),
  decommissionedAt__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudInstanceId__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  coreCount__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  totalMemory__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  remoteProfilingStatesNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  adComputerMember__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatCreatedAt__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  totalMemory__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  ids: _configSchema.schema.nullable(_configSchema.schema.string()),
  agentVersionsNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  locationEnabled: _configSchema.schema.nullable(_configSchema.schema.string()),
  locationIdsNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  osTypes: _configSchema.schema.nullable(_configSchema.schema.string()),
  encryptedApplications: _configSchema.schema.nullable(_configSchema.schema.string()),
  filterId: _configSchema.schema.nullable(_configSchema.schema.string()),
  decommissionedAt__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  adUserMember__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  uuid: _configSchema.schema.nullable(_configSchema.schema.string()),
  coreCount__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  coreCount__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudNetwork__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  clusterName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  cpuCount__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  query: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastActiveDate__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  rangerStatus: _configSchema.schema.nullable(_configSchema.schema.string()),
  domains: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudProvider: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastActiveDate__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  scanStatuses: _configSchema.schema.nullable(_configSchema.schema.string()),
  hasLocalConfiguration: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkStatuses: _configSchema.schema.nullable(_configSchema.schema.string()),
  isPendingUninstall: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  cpuCount__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  consoleMigrationStatuses: _configSchema.schema.nullable(_configSchema.schema.string()),
  adQuery: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedAt__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  adComputerName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudInstanceSize__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  registeredAt__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkQuarantineEnabled: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudAccount__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  cloudLocation__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  rangerVersions: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkInterfaceGatewayMacAddress__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  uuid__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  agentNamespace__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  K8SNodeLabels__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  adQuery__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  K8SType__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  countsFor: _configSchema.schema.nullable(_configSchema.schema.string()),
  totalMemory__lt: _configSchema.schema.nullable(_configSchema.schema.string()),
  externalId__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  filteredSiteIds: _configSchema.schema.nullable(_configSchema.schema.string()),
  decommissionedAt__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  cpuCount__gt: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatHidden: _configSchema.schema.nullable(_configSchema.schema.string()),
  isUninstalled: _configSchema.schema.nullable(_configSchema.schema.string()),
  computerName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastActiveDate__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  adUserName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  isActive: _configSchema.schema.nullable(_configSchema.schema.string()),
  userActionsNeeded: _configSchema.schema.nullable(_configSchema.schema.string()),
  threatCreatedAt__lte: _configSchema.schema.nullable(_configSchema.schema.string()),
  domainsNin: _configSchema.schema.nullable(_configSchema.schema.string()),
  operationalStates: _configSchema.schema.nullable(_configSchema.schema.string()),
  externalIp__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  isDecommissioned: _configSchema.schema.nullable(_configSchema.schema.string()),
  networkInterfacePhysical__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastActiveDate__gte: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  cpuCount__between: _configSchema.schema.nullable(_configSchema.schema.string()),
  lastLoggedInUserName__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  awsRole__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  K8SVersion__contains: _configSchema.schema.nullable(_configSchema.schema.string()),
  alertIds: AlertIds
});
exports.SentinelOneBaseFilterSchema = SentinelOneBaseFilterSchema;
const SentinelOneKillProcessParamsSchema = SentinelOneBaseFilterSchema.extends({
  processName: _configSchema.schema.string()
});
exports.SentinelOneKillProcessParamsSchema = SentinelOneKillProcessParamsSchema;
const SentinelOneIsolateHostParamsSchema = SentinelOneBaseFilterSchema;
exports.SentinelOneIsolateHostParamsSchema = SentinelOneIsolateHostParamsSchema;
const SentinelOneGetAgentsParamsSchema = SentinelOneBaseFilterSchema;
exports.SentinelOneGetAgentsParamsSchema = SentinelOneGetAgentsParamsSchema;
const SentinelOneGetRemoteScriptsStatusParams = _configSchema.schema.object({
  parentTaskId: _configSchema.schema.string()
});
exports.SentinelOneGetRemoteScriptsStatusParams = SentinelOneGetRemoteScriptsStatusParams;
const SentinelOneExecuteScriptResponseSchema = _configSchema.schema.object({
  errors: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))),
  data: _configSchema.schema.nullable(_configSchema.schema.object({
    pendingExecutionId: _configSchema.schema.nullable(_configSchema.schema.string()),
    affected: _configSchema.schema.nullable(_configSchema.schema.number()),
    parentTaskId: _configSchema.schema.nullable(_configSchema.schema.string()),
    pending: _configSchema.schema.nullable(_configSchema.schema.boolean())
  }))
});
exports.SentinelOneExecuteScriptResponseSchema = SentinelOneExecuteScriptResponseSchema;
const SentinelOneKillProcessResponseSchema = SentinelOneExecuteScriptResponseSchema;
exports.SentinelOneKillProcessResponseSchema = SentinelOneKillProcessResponseSchema;
const SentinelOneKillProcessSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.KILL_PROCESS),
  subActionParams: SentinelOneKillProcessParamsSchema
});
exports.SentinelOneKillProcessSchema = SentinelOneKillProcessSchema;
const SentinelOneIsolateHostSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.ISOLATE_HOST),
  subActionParams: SentinelOneIsolateHostParamsSchema
});
exports.SentinelOneIsolateHostSchema = SentinelOneIsolateHostSchema;
const SentinelOneReleaseHostSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.RELEASE_HOST),
  subActionParams: SentinelOneIsolateHostParamsSchema
});
exports.SentinelOneReleaseHostSchema = SentinelOneReleaseHostSchema;
const SentinelOneExecuteScriptSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.EXECUTE_SCRIPT),
  subActionParams: SentinelOneExecuteScriptParamsSchema
});
exports.SentinelOneExecuteScriptSchema = SentinelOneExecuteScriptSchema;
const SentinelOneActionParamsSchema = _configSchema.schema.oneOf([SentinelOneKillProcessSchema, SentinelOneIsolateHostSchema, SentinelOneReleaseHostSchema, SentinelOneExecuteScriptSchema]);
exports.SentinelOneActionParamsSchema = SentinelOneActionParamsSchema;