"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamingResponseSchema = exports.StreamActionParamsSchema = exports.SecretsSchema = exports.RunActionResponseSchema = exports.RunActionParamsSchema = exports.InvokeAIActionResponseSchema = exports.InvokeAIActionParamsSchema = exports.DashboardActionResponseSchema = exports.DashboardActionParamsSchema = exports.ConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Connector schema
const ConfigSchema = _configSchema.schema.object({
  apiUrl: _configSchema.schema.string(),
  defaultModel: _configSchema.schema.string({
    defaultValue: _constants.DEFAULT_BEDROCK_MODEL
  })
});
exports.ConfigSchema = ConfigSchema;
const SecretsSchema = _configSchema.schema.object({
  accessKey: _configSchema.schema.string(),
  secret: _configSchema.schema.string()
});
exports.SecretsSchema = SecretsSchema;
const RunActionParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.string(),
  model: _configSchema.schema.maybe(_configSchema.schema.string())
});
exports.RunActionParamsSchema = RunActionParamsSchema;
const InvokeAIActionParamsSchema = _configSchema.schema.object({
  messages: _configSchema.schema.arrayOf(_configSchema.schema.object({
    role: _configSchema.schema.string(),
    content: _configSchema.schema.string()
  })),
  model: _configSchema.schema.maybe(_configSchema.schema.string())
});
exports.InvokeAIActionParamsSchema = InvokeAIActionParamsSchema;
const InvokeAIActionResponseSchema = _configSchema.schema.object({
  message: _configSchema.schema.string()
});
exports.InvokeAIActionResponseSchema = InvokeAIActionResponseSchema;
const StreamActionParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.string(),
  model: _configSchema.schema.maybe(_configSchema.schema.string())
});
exports.StreamActionParamsSchema = StreamActionParamsSchema;
const RunActionResponseSchema = _configSchema.schema.object({
  completion: _configSchema.schema.string(),
  stop_reason: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'ignore'
});
exports.RunActionResponseSchema = RunActionResponseSchema;
const StreamingResponseSchema = _configSchema.schema.any();

// Run action schema
exports.StreamingResponseSchema = StreamingResponseSchema;
const DashboardActionParamsSchema = _configSchema.schema.object({
  dashboardId: _configSchema.schema.string()
});
exports.DashboardActionParamsSchema = DashboardActionParamsSchema;
const DashboardActionResponseSchema = _configSchema.schema.object({
  available: _configSchema.schema.boolean()
});
exports.DashboardActionResponseSchema = DashboardActionResponseSchema;