"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryFormTypeChooser = exports.ExperimentalBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _types = require("../types");
var _util = require("../util");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExperimentalBadge = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
  size: "s",
  label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.experimentalLabel', {
    defaultMessage: 'Technical preview'
  }),
  tooltipContent: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.experimentalDescription', {
    defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
  }),
  tooltipPosition: "bottom"
}));
exports.ExperimentalBadge = ExperimentalBadge;
ExperimentalBadge.displayName = 'ExperimentalBadge';
const QueryFormTypeChooser = ({
  searchType,
  onFormTypeSelect
}) => {
  const {
    uiSettings
  } = (0, _util.useTriggerUiActionServices)();
  const isEsqlEnabled = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('discover:enableESQL');
  const formTypeItems = (0, _react.useMemo)(() => {
    const items = [{
      formType: _types.SearchType.searchSource,
      label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.kqlOrLuceneFormTypeLabel', {
        defaultMessage: 'KQL or Lucene'
      }),
      description: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.kqlOrLuceneFormTypeDescription', {
        defaultMessage: 'Use KQL or Lucene to define a text-based query.'
      })
    }, {
      formType: _types.SearchType.esQuery,
      label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.queryDslFormTypeLabel', {
        defaultMessage: 'Query DSL'
      }),
      description: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.queryDslFormTypeDescription', {
        defaultMessage: 'Use the Elasticsearch Query DSL to define a query.'
      })
    }];
    if (isEsqlEnabled) {
      items.push({
        formType: _types.SearchType.esqlQuery,
        label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.esqlFormTypeLabel', {
          defaultMessage: 'ES|QL'
        }),
        description: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.esqlFormTypeDescription', {
          defaultMessage: 'Use ES|QL to define a text-based query.'
        })
      });
    }
    return items;
  }, [isEsqlEnabled]);
  if (searchType) {
    const activeFormTypeItem = formTypeItems.find(item => item.formType === searchType);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      "data-test-subj": "selectedRuleFormTypeTitle"
    }, /*#__PURE__*/_react.default.createElement("h5", null, activeFormTypeItem === null || activeFormTypeItem === void 0 ? void 0 : activeFormTypeItem.label))), (activeFormTypeItem === null || activeFormTypeItem === void 0 ? void 0 : activeFormTypeItem.formType) === _types.SearchType.esqlQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ExperimentalBadge, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "cross",
      color: "danger",
      "data-test-subj": "queryFormTypeChooserCancel",
      "aria-label": _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.cancelSelectionAriaLabel', {
        defaultMessage: 'Cancel selection'
      }),
      onClick: () => onFormTypeSelect(null)
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      "data-test-subj": "selectedRuleFormTypeDescription"
    }, activeFormTypeItem === null || activeFormTypeItem === void 0 ? void 0 : activeFormTypeItem.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": "queryFormTypeChooserTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.selectQueryFormTypeLabel",
    defaultMessage: "Select a query type"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    gutterSize: "m",
    size: "m",
    maxWidth: false
  }, formTypeItems.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    wrapText: true,
    key: `form-type-${item.formType}`,
    "data-test-subj": `queryFormType_${item.formType}`,
    color: "primary",
    label: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("strong", null, item.label)), item.formType === _types.SearchType.esqlQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ExperimentalBadge, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, item.description))),
    onClick: () => onFormTypeSelect(item.formType)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.QueryFormTypeChooser = QueryFormTypeChooser;