"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../../constants");
var _components = require("../../../../../components");
var _navigation = require("../../../../../services/navigation");
var _snapshot_state = require("./snapshot_state");
var _app_context = require("../../../../../app_context");
var _summaries = require("../../../../../components/summaries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabSummary = ({
  snapshotDetails
}) => {
  const {
    version,
    // TODO: Add a tooltip explaining that: a false value means that the cluster global state
    // is not stored as part of the snapshot.
    includeGlobalState,
    featureStates,
    dataStreams,
    indices,
    state,
    startTimeInMillis,
    endTimeInMillis,
    durationInMillis,
    uuid,
    policyName
  } = snapshotDetails;
  const {
    history
  } = (0, _app_context.useServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "version"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.itemVersionLabel",
    defaultMessage: "Version"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, version)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "uuid"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.itemUuidLabel",
    defaultMessage: "UUID"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, uuid))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "state"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.itemStateLabel",
    defaultMessage: "State"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, /*#__PURE__*/_react.default.createElement(_snapshot_state.SnapshotState, {
    state: state
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "duration"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.itemDurationLabel",
    defaultMessage: "Duration"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, state === _constants.SNAPSHOT_STATE.IN_PROGRESS ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : /*#__PURE__*/_react.default.createElement(_components.DataPlaceholder, {
    data: durationInMillis
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.itemDurationValueLabel",
    "data-test-subj": "srSnapshotDetailsDurationValue",
    defaultMessage: "{seconds} {seconds, plural, one {second} other {seconds}}",
    values: {
      seconds: Math.ceil(durationInMillis / 1000)
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "includeGlobalState"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.itemIncludeGlobalStateLabel",
    defaultMessage: "Includes global state"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, includeGlobalState === false ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "withoutGlobalState",
    id: "xpack.snapshotRestore.snapshotDetails.itemIncludeGlobalStateNoLabel",
    defaultMessage: "No"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "withGlobalState",
    id: "xpack.snapshotRestore.snapshotDetails.itemIncludeGlobalStateYesLabel",
    defaultMessage: "Yes"
  }))), /*#__PURE__*/_react.default.createElement(_summaries.SnapshotFeatureStatesSummary, {
    featureStates: featureStates
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "indices"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.itemIndicesLabel",
    defaultMessage: "Indices ({indicesCount})",
    values: {
      indicesCount: indices.length
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, /*#__PURE__*/_react.default.createElement(_components.CollapsibleIndicesList, {
    indices: indices
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "dataStreams"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.itemDataStreamsLabel",
    defaultMessage: "Data streams ({dataStreamsCount})",
    values: {
      dataStreamsCount: dataStreams.length
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, /*#__PURE__*/_react.default.createElement(_components.CollapsibleDataStreamsList, {
    dataStreams: dataStreams
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "startTime"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.itemStartTimeLabel",
    defaultMessage: "Start time"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, /*#__PURE__*/_react.default.createElement(_components.DataPlaceholder, {
    data: startTimeInMillis
  }, /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
    epochMs: startTimeInMillis
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "endTime"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.itemEndTimeLabel",
    defaultMessage: "End time"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, state === _constants.SNAPSHOT_STATE.IN_PROGRESS ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : /*#__PURE__*/_react.default.createElement(_components.DataPlaceholder, {
    data: endTimeInMillis
  }, /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
    epochMs: endTimeInMillis
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, policyName ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "policy"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.snapshotDetails.createdByLabel",
    defaultMessage: "Created by"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToPolicy)(policyName)), policyName))) : null));
};
exports.TabSummary = TabSummary;