"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _constants = require("../../../../constants");
var _app_context = require("../../../../app_context");
var _navigation = require("../../../../services/navigation");
var _components = require("../../../../components");
var _snapshot_search_bar = require("./snapshot_search_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLastSuccessfulManagedSnapshot = snapshots => {
  const successfulSnapshots = snapshots.filter(({
    state,
    repository,
    managedRepository
  }) => repository === managedRepository && state === 'SUCCESS').sort((a, b) => {
    return +new Date(b.endTime) - +new Date(a.endTime);
  });
  return successfulSnapshots[0];
};
const SnapshotTable = props => {
  const {
    snapshots,
    repositories,
    reload,
    onSnapshotDeleted,
    listParams,
    setListParams,
    totalItemCount,
    isLoading
  } = props;
  const {
    i18n,
    uiMetricService,
    history
  } = (0, _app_context.useServices)();
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const lastSuccessfulManagedSnapshot = getLastSuccessfulManagedSnapshot(snapshots);
  const columns = [{
    field: 'snapshot',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.snapshotColumnTitle', {
      defaultMessage: 'Snapshot'
    }),
    truncateText: false,
    sortable: true,
    render: (snapshotId, snapshot) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _shared_imports.reactRouterNavigate)(history, (0, _navigation.linkToSnapshot)(snapshot.repository, snapshotId), () => uiMetricService.trackUiMetric(_constants.UIM_SNAPSHOT_SHOW_DETAILS_CLICK)), {
      "data-test-subj": "snapshotLink"
    }), snapshotId)
  }, {
    field: 'repository',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.repositoryColumnTitle', {
      defaultMessage: 'Repository'
    }),
    truncateText: false,
    sortable: true,
    render: repositoryName => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _shared_imports.reactRouterNavigate)(history, (0, _navigation.linkToRepository)(repositoryName)), {
      "data-test-subj": "repositoryLink"
    }), repositoryName)
  }, {
    field: 'indices',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.indicesColumnTitle', {
      defaultMessage: 'Indices'
    }),
    truncateText: true,
    sortable: true,
    width: '100px',
    render: indices => indices.length
  }, {
    field: 'shards.total',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.shardsColumnTitle', {
      defaultMessage: 'Shards'
    }),
    truncateText: true,
    sortable: true,
    width: '100px',
    render: totalShards => totalShards
  }, {
    field: 'shards.failed',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.failedShardsColumnTitle', {
      defaultMessage: 'Failed shards'
    }),
    truncateText: true,
    sortable: true,
    width: '100px',
    render: failedShards => failedShards
  }, {
    field: 'startTimeInMillis',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.startTimeColumnTitle', {
      defaultMessage: 'Date created'
    }),
    truncateText: false,
    sortable: true,
    render: startTimeInMillis => /*#__PURE__*/_react.default.createElement(_components.DataPlaceholder, {
      data: startTimeInMillis
    }, /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
      epochMs: startTimeInMillis
    }))
  }, {
    field: 'durationInMillis',
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.durationColumnTitle', {
      defaultMessage: 'Duration'
    }),
    truncateText: true,
    sortable: true,
    width: '100px',
    render: (durationInMillis, {
      state
    }) => {
      if (state === _constants.SNAPSHOT_STATE.IN_PROGRESS) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "m"
        });
      }
      return /*#__PURE__*/_react.default.createElement(_components.DataPlaceholder, {
        data: durationInMillis
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.snapshotList.table.durationColumnValueLabel",
        defaultMessage: "{seconds}s",
        values: {
          seconds: Math.ceil(durationInMillis / 1000)
        }
      }));
    }
  }, {
    name: i18n.translate('xpack.snapshotRestore.snapshotList.table.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      render: ({
        snapshot,
        repository,
        state
      }) => {
        const canRestore = state === _constants.SNAPSHOT_STATE.SUCCESS || state === _constants.SNAPSHOT_STATE.PARTIAL;
        const label = canRestore ? i18n.translate('xpack.snapshotRestore.snapshotList.table.actionRestoreTooltip', {
          defaultMessage: 'Restore'
        }) : state === _constants.SNAPSHOT_STATE.IN_PROGRESS ? i18n.translate('xpack.snapshotRestore.snapshotList.table.actionRestoreDisabledInProgressTooltip', {
          defaultMessage: `Can't restore in-progress snapshot`
        }) : i18n.translate('xpack.snapshotRestore.snapshotList.table.actionRestoreDisabledInvalidTooltip', {
          defaultMessage: `Can't restore invalid snapshot`
        });
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: label
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
          "aria-label": i18n.translate('xpack.snapshotRestore.snapshotList.table.actionRestoreAriaLabel', {
            defaultMessage: 'Store snapshot `{name}`',
            values: {
              name: snapshot
            }
          }),
          iconType: "importAction",
          color: "primary",
          "data-test-subj": "srsnapshotListRestoreActionButton"
        }, (0, _shared_imports.reactRouterNavigate)(history, (0, _navigation.linkToRestoreSnapshot)(repository, snapshot)), {
          isDisabled: !canRestore
        })));
      }
    }, {
      render: ({
        snapshot,
        repository
      }) => {
        return /*#__PURE__*/_react.default.createElement(_components.SnapshotDeleteProvider, null, deleteSnapshotPrompt => {
          const isDeleteDisabled = Boolean(lastSuccessfulManagedSnapshot) ? snapshot === lastSuccessfulManagedSnapshot.snapshot : false;
          const label = isDeleteDisabled ? i18n.translate('xpack.snapshotRestore.snapshotList.table.deleteManagedRepositorySnapshotTooltip', {
            defaultMessage: 'You must store the last successful snapshot in a managed repository.'
          }) : i18n.translate('xpack.snapshotRestore.snapshotList.table.actionDeleteTooltip', {
            defaultMessage: 'Delete'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: label
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            "aria-label": i18n.translate('xpack.snapshotRestore.snapshotList.table.actionDeleteAriaLabel', {
              defaultMessage: `Delete snapshot '{name}'`,
              values: {
                name: snapshot
              }
            }),
            iconType: "trash",
            color: "danger",
            "data-test-subj": "srsnapshotListDeleteActionButton",
            onClick: () => deleteSnapshotPrompt([{
              snapshot,
              repository
            }], onSnapshotDeleted),
            isDisabled: isDeleteDisabled
          }));
        });
      }
    }],
    width: '100px'
  }];
  const sorting = {
    sort: {
      field: listParams.sortField,
      direction: listParams.sortDirection
    }
  };
  const pagination = {
    pageIndex: listParams.pageIndex,
    pageSize: listParams.pageSize,
    totalItemCount,
    pageSizeOptions: [10, 20, 50]
  };
  const selection = {
    onSelectionChange: newSelectedItems => setSelectedItems(newSelectedItems),
    selectable: ({
      snapshot
    }) => Boolean(lastSuccessfulManagedSnapshot) ? snapshot !== lastSuccessfulManagedSnapshot.snapshot : true,
    selectableMessage: selectable => {
      if (!selectable) {
        return i18n.translate('xpack.snapshotRestore.snapshotList.table.deleteManagedRepositorySnapshotDescription', {
          defaultMessage: 'You must retain the last successful snapshot in a managed repository.'
        });
      }
      return '';
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_snapshot_search_bar.SnapshotSearchBar, {
    listParams: listParams,
    setListParams: setListParams,
    reload: reload,
    selectedItems: selectedItems,
    onSnapshotDeleted: onSnapshotDeleted,
    repositories: repositories
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: snapshots,
    itemId: "uuid",
    columns: columns,
    sorting: sorting,
    onChange: criteria => {
      var _ref, _ref2;
      const {
        page: {
          index,
          size
        } = {},
        sort: {
          field,
          direction
        } = {}
      } = criteria;
      setListParams({
        ...listParams,
        sortField: (_ref = field) !== null && _ref !== void 0 ? _ref : listParams.sortField,
        sortDirection: (_ref2 = direction) !== null && _ref2 !== void 0 ? _ref2 : listParams.sortDirection,
        pageIndex: index !== null && index !== void 0 ? index : listParams.pageIndex,
        pageSize: size !== null && size !== void 0 ? size : listParams.pageSize
      });
    },
    loading: isLoading,
    isSelectable: true,
    selection: selection,
    pagination: pagination,
    rowProps: () => ({
      'data-test-subj': 'row'
    }),
    cellProps: () => ({
      'data-test-subj': 'cell'
    }),
    "data-test-subj": "snapshotTable"
  }));
};
exports.SnapshotTable = SnapshotTable;