"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyDetails = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _app_context = require("../../../../app_context");
var _shared_imports = require("../../../../../shared_imports");
var _constants = require("../../../../constants");
var _http = require("../../../../services/http");
var _navigation = require("../../../../services/navigation");
var _components = require("../../../../components");
var _tabs = require("./tabs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAB_SUMMARY = 'summary';
const TAB_HISTORY = 'success';
const tabToUiMetricMap = {
  [TAB_SUMMARY]: _constants.UIM_POLICY_DETAIL_PANEL_SUMMARY_TAB,
  [TAB_HISTORY]: _constants.UIM_POLICY_DETAIL_PANEL_HISTORY_TAB
};
const PolicyDetails = ({
  policyName,
  onClose,
  onPolicyDeleted,
  onPolicyExecuted
}) => {
  const {
    i18n,
    uiMetricService,
    history
  } = (0, _app_context.useServices)();
  const {
    error,
    data: policyDetails,
    resendRequest: reload
  } = (0, _http.useLoadPolicy)(policyName);
  const [activeTab, setActiveTab] = (0, _react.useState)(TAB_SUMMARY);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);

  // Reset tab when we look at a different policy
  (0, _react.useEffect)(() => {
    setActiveTab(TAB_SUMMARY);
  }, [policyName]);
  const tabOptions = [{
    id: TAB_SUMMARY,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.summaryTabTitle",
      defaultMessage: "Summary"
    })
  }, {
    id: TAB_HISTORY,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.historyTabTitle",
      defaultMessage: "History"
    })
  }];
  const renderTabs = () => /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabOptions.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => {
      uiMetricService.trackUiMetric(tabToUiMetricMap[tab.id]);
      setActiveTab(tab.id);
    },
    isSelected: tab.id === activeTab,
    key: tab.id,
    "data-test-subj": "tab"
  }, tab.name)));
  const renderBody = () => {
    if (policyDetails) {
      const {
        policy
      } = policyDetails;
      switch (activeTab) {
        case TAB_HISTORY:
          return /*#__PURE__*/_react.default.createElement(_tabs.TabHistory, {
            policy: policy
          });
        default:
          return /*#__PURE__*/_react.default.createElement(_tabs.TabSummary, {
            policy: policy
          });
      }
    }
    if (error) {
      return renderError();
    }
    return renderLoading();
  };
  const renderLoading = () => {
    return /*#__PURE__*/_react.default.createElement(_components.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.loadingPolicyDescription",
      defaultMessage: "Loading policy\u2026"
    }));
  };
  const renderError = () => {
    const notFound = error.status === 404;
    const errorObject = notFound ? {
      data: {
        error: i18n.translate('xpack.snapshotRestore.policyDetails.policyNotFoundErrorMessage', {
          defaultMessage: `The policy '{name}' does not exist.`,
          values: {
            name: policyName
          }
        })
      }
    } : error;
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyDetails.loadingPolicyErrorTitle",
        defaultMessage: "Error loading policy"
      }),
      error: errorObject
    });
  };
  const renderFooter = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      flush: "left",
      onClick: onClose,
      "data-test-subj": "srPolicyDetailsFlyoutCloseButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.closeButtonLabel",
      defaultMessage: "Close"
    }))), policyDetails ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.PolicyExecuteProvider, null, executePolicyPrompt => {
      return /*#__PURE__*/_react.default.createElement(_components.PolicyDeleteProvider, null, deletePolicyPrompt => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
          id: "policyActionMenu",
          button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            "data-test-subj": "policyActionMenuButton",
            iconSide: "right",
            onClick: () => setIsPopoverOpen(!isPopoverOpen),
            iconType: "arrowDown",
            fill: true
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.snapshotRestore.policyDetails.manageButtonLabel",
            defaultMessage: "Manage policy"
          })),
          isOpen: isPopoverOpen,
          closePopover: () => setIsPopoverOpen(false),
          panelPaddingSize: "none",
          anchorPosition: "rightUp",
          repositionOnScroll: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
          "data-test-subj": "policyActionContextMenu",
          initialPanelId: 0,
          panels: [{
            id: 0,
            title: i18n.translate('xpack.snapshotRestore.policyDetails.managePanelTitle', {
              defaultMessage: 'Policy options'
            }),
            items: [{
              name: i18n.translate('xpack.snapshotRestore.policyDetails.executeButtonLabel', {
                defaultMessage: 'Run now'
              }),
              icon: 'play',
              onClick: () => {
                executePolicyPrompt(policyName, () =>
                // Wait a little bit for policy to execute before reloading policy table
                // and policy details so that History tab information is updated with
                // results of the execution
                setTimeout(() => {
                  onPolicyExecuted();
                  reload();
                }, 2000));
              },
              disabled: Boolean(policyDetails.policy.inProgress)
            }, {
              name: i18n.translate('xpack.snapshotRestore.policyDetails.editButtonLabel', {
                defaultMessage: 'Edit'
              }),
              icon: 'pencil',
              ...(0, _public.reactRouterNavigate)(history, (0, _navigation.linkToEditPolicy)(policyName))
            }, {
              name: i18n.translate('xpack.snapshotRestore.policyDetails.deleteButtonLabel', {
                defaultMessage: 'Delete'
              }),
              icon: 'trash',
              disabled: policyDetails.policy.isManagedPolicy,
              onClick: () => deletePolicyPrompt([policyName], onPolicyDeleted)
            }]
          }]
        }));
      });
    })) : null);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "policyDetail",
    "aria-labelledby": "srPolicyDetailsFlyoutTitle",
    size: "m",
    maxWidth: 550
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "srPolicyDetailsFlyoutTitle",
    "data-test-subj": "title"
  }, policyName, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "refresh",
    color: "text",
    "aria-label": i18n.translate('xpack.snapshotRestore.policyDetails.reloadButtonAriaLabel', {
      defaultMessage: 'Reload'
    }),
    onClick: () => reload()
  }))), policyDetails && policyDetails.policy && policyDetails.policy.inProgress ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_components.InlineLoading, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToSnapshot)(policyDetails.policy.repository, policyDetails.policy.inProgress.snapshotName)), {
    "data-test-subj": "inProgressSnapshotLink"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.inProgressSnapshotLinkText",
    defaultMessage: "'{snapshotName}' in progress",
    values: {
      snapshotName: policyDetails.policy.inProgress.snapshotName
    }
  })))) : null, renderTabs()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "content"
  }, renderBody()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, renderFooter()));
};
exports.PolicyDetails = PolicyDetails;