"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BrowserShortUrlClientFactory = void 0;
var _short_url_client = require("./short_url_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class BrowserShortUrlClientFactory {
  constructor(dependencies) {
    this.dependencies = dependencies;
  }
  get(params) {
    const client = new _short_url_client.BrowserShortUrlClient(this.dependencies);
    return client;
  }
}
exports.BrowserShortUrlClientFactory = BrowserShortUrlClientFactory;