"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorMessage = getErrorMessage;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getErrorMessage(error) {
  if (typeof error === 'string') {
    return error;
  }
  if (typeof error === 'object') {
    var _body;
    return (error === null || error === void 0 ? void 0 : (_body = error.body) === null || _body === void 0 ? void 0 : _body.message) || '';
  }
  return '';
}