"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createServerlessSearchSideNavComponent = void 0;
var _sharedUxChromeNavigation = require("@kbn/shared-ux-chrome-navigation");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18n_string = require("../../common/i18n_string");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const navigationTree = {
  body: [{
    type: 'recentlyAccessed'
  }, {
    type: 'navGroup',
    id: 'search_project_nav',
    title: 'Elasticsearch',
    icon: 'logoElasticsearch',
    defaultIsCollapsed: false,
    isCollapsible: false,
    breadcrumbStatus: 'hidden',
    children: [{
      id: 'dev_tools',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.devTools', {
        defaultMessage: 'Dev Tools'
      }),
      link: 'dev_tools:console',
      getIsActive: ({
        pathNameSerialized,
        prepend
      }) => {
        return pathNameSerialized.startsWith(prepend('/app/dev_tools'));
      },
      spaceBefore: 'l'
    }, {
      link: 'discover',
      spaceBefore: 'm'
    }, {
      link: 'dashboards',
      getIsActive: ({
        pathNameSerialized,
        prepend
      }) => {
        return pathNameSerialized.startsWith(prepend('/app/dashboards'));
      }
    }, {
      link: 'visualize',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.visualize', {
        defaultMessage: 'Visualizations'
      }),
      getIsActive: ({
        pathNameSerialized,
        prepend
      }) => {
        return pathNameSerialized.startsWith(prepend('/app/visualize')) || pathNameSerialized.startsWith(prepend('/app/lens')) || pathNameSerialized.startsWith(prepend('/app/maps'));
      }
    }, {
      link: 'management:triggersActions',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.alerts', {
        defaultMessage: 'Alerts'
      })
    }, {
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.content.indices', {
        defaultMessage: 'Index Management'
      }),
      link: 'management:index_management',
      breadcrumbStatus: 'hidden' /* management sub-pages set their breadcrumbs themselves */,
      spaceBefore: 'm'
    }, {
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.content.pipelines', {
        defaultMessage: 'Pipelines'
      }),
      link: 'management:ingest_pipelines',
      breadcrumbStatus: 'hidden' /* management sub-pages set their breadcrumbs themselves */
    }, {
      title: _i18n_string.CONNECTORS_LABEL,
      link: 'serverlessConnectors'
    }, {
      link: 'management:api_keys',
      breadcrumbStatus: 'hidden' /* management sub-pages set their breadcrumbs themselves */,
      spaceBefore: 'm'
    }]
  }],
  footer: [{
    type: 'navItem',
    id: 'search_getting_started',
    title: _i18n.i18n.translate('xpack.serverlessSearch.nav.gettingStarted', {
      defaultMessage: 'Get started'
    }),
    icon: 'launch',
    link: 'serverlessElasticsearch'
  }, {
    type: 'navGroup',
    id: 'project_settings_project_nav',
    title: _i18n.i18n.translate('xpack.serverlessSearch.nav.projectSettings', {
      defaultMessage: 'Project settings'
    }),
    icon: 'gear',
    breadcrumbStatus: 'hidden',
    children: [{
      link: 'management',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.mngt', {
        defaultMessage: 'Management'
      })
    }, {
      id: 'cloudLinkDeployment',
      cloudLink: 'deployment',
      title: _i18n.i18n.translate('xpack.serverlessSearch.nav.performance', {
        defaultMessage: 'Performance'
      })
    }, {
      id: 'cloudLinkUserAndRoles',
      cloudLink: 'userAndRoles'
    }, {
      id: 'cloudLinkBilling',
      cloudLink: 'billingAndSub'
    }]
  }]
};
const createServerlessSearchSideNavComponent = (core, {
  serverless,
  cloud
}) => () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxChromeNavigation.NavigationKibanaProvider, {
    core: core,
    serverless: serverless,
    cloud: cloud
  }, /*#__PURE__*/_react.default.createElement(_sharedUxChromeNavigation.DefaultNavigation, {
    navigationTree: navigationTree,
    dataTestSubj: "svlSearchSideNav"
  }));
};
exports.createServerlessSearchSideNavComponent = createServerlessSearchSideNavComponent;