"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetBasePath = void 0;
var _common = require("../../../common");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAssetBasePath = () => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  return http.basePath.prepend(`/plugins/${_common.PLUGIN_ID}/assets`);
};
exports.useAssetBasePath = useAssetBasePath;