"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_connector_types = require("../hooks/api/use_connector_types");
var _use_create_connector = require("../hooks/api/use_create_connector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CONNECTOR_TYPES_DISPLAY = ['azure_blob_storage', 'sharepoint_online', 's3', 'mongodb', 'google_cloud_storage'];
const ConnectorsCallout = () => {
  const {
    data
  } = (0, _use_connector_types.useConnectorTypes)();
  const {
    createConnector,
    isLoading
  } = (0, _use_create_connector.useCreateConnector)();
  const allConnectorTypes = data === null || data === void 0 ? void 0 : data.connectors;
  const connectorTypes = allConnectorTypes ? CONNECTOR_TYPES_DISPLAY.map(type => allConnectorTypes.find(connType => connType.serviceType === type)) : undefined;
  const showConnectors = connectorTypes && connectorTypes.length;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.selectClient.connectorsCallout.title', {
      defaultMessage: 'Sync your data using a connector client'
    }),
    size: "m",
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.selectClient.connectorsCallout.description",
    defaultMessage: "Sync a range of popular third-party data sources to Elasticsearch, by deploying open code Elastic connectors on your own infrastructure."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    "data-test-subj": "connectors-callout-cta",
    onClick: () => createConnector(),
    isLoading: isLoading
  }, _i18n.i18n.translate('xpack.serverlessSearch.selectClient.connectorsCallout.cta', {
    defaultMessage: 'Create a connector'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), showConnectors && connectorTypes.map(connectorType => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: connectorType.serviceType
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: connectorType.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xxl",
    title: connectorType.name,
    id: connectorType.serviceType,
    type: connectorType.iconPath
  })))), showConnectors && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.selectClient.connectorsCallout.etc",
    defaultMessage: "and more"
  }))))));
};
exports.ConnectorsCallout = ConnectorsCallout;