"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyConnectorsPrompt = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../../../../common");
var _use_connector_types = require("../../hooks/api/use_connector_types");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyConnectorsPrompt = () => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const {
    data: connectorTypes
  } = (0, _use_connector_types.useConnectorTypes)();
  const assetBasePath = http.basePath.prepend(`/plugins/${_common.PLUGIN_ID}/assets`);
  const connectorsPath = assetBasePath + '/connectors.svg';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xxl",
    type: connectorsPath
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.title', {
    defaultMessage: 'Create a connector'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.description', {
    defaultMessage: "To set up and deploy a connector you'll be working between the third-party data source, your terminal, and the Elasticsearch serverless UI. The high level process looks like this:"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "primary",
    size: "l",
    type: "documents"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.guideOneDescription', {
    defaultMessage: "Choose a data source you'd like to sync"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "primary",
    size: "l",
    type: connectorsPath
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.connectorsEmpty.guideTwoDescription",
    defaultMessage: "Deploy connector code on your own infrastructure by running from {source}, or using {docker}",
    values: {
      source: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "serverlessSearchEmptyConnectorsPromptSourceLink",
        href: "TODO TODO TODO"
      }, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.sourceLabel', {
        defaultMessage: 'source'
      })),
      docker: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "serverlessSearchEmptyConnectorsPromptDockerLink",
        href: "TODO TODO TODO"
      }, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.dockerLabel', {
        defaultMessage: 'Docker'
      }))
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "primary",
    size: "l",
    type: "documents"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "sortRight"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "primary",
    size: "l",
    type: connectorsPath
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "sortRight"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "primary",
    size: "l",
    type: "logoElastic"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.guideThreeDescription', {
    defaultMessage: 'Enter access and connection details for your data source and run your first sync'
  }))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchEmptyConnectorsPromptCreateConnectorButton",
    fill: true,
    iconType: "plusInCircleFilled"
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.createConnector', {
    defaultMessage: 'Create connector'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.availableConnectors', {
    defaultMessage: 'Available connectors'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, connectorTypes === null || connectorTypes === void 0 ? void 0 : connectorTypes.connectors.map(connectorType => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: connectorType.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: connectorType.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    title: connectorType.name,
    id: connectorType.serviceType,
    type: connectorType.iconPath
  })))))));
};
exports.EmptyConnectorsPrompt = EmptyConnectorsPrompt;