"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditDescription = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _i18n_string = require("../../../../common/i18n_string");
var _use_kibana = require("../../hooks/use_kibana");
var _use_connector = require("../../hooks/api/use_connector");
var _use_error_toast = require("../../hooks/use_error_toast");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditDescription = ({
  connector
}) => {
  const [isEditing, setIsEditing] = (0, _react2.useState)(false);
  const [newDescription, setNewDescription] = (0, _react2.useState)(connector.description || '');
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const showErrorToast = (0, _use_error_toast.useShowErrorToast)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  (0, _react2.useEffect)(() => setNewDescription(connector.description || ''), [connector.description]);
  const {
    isLoading,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async inputDescription => {
      const body = {
        description: inputDescription
      };
      await http.post(`/internal/serverless_search/connectors/${connector.id}/description`, {
        body: JSON.stringify(body)
      });
      return inputDescription;
    },
    onError: error => showErrorToast(error, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectorDescription', {
      defaultMessage: 'Error updating description'
    })),
    onSuccess: successData => {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          description: successData
        }
      });
      queryClient.invalidateQueries(queryKey);
      setIsEditing(false);
    }
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.serverlessSearch.connectors.descriptionHelpText', {
      defaultMessage: 'Optional description for your connector.'
    }),
    label: _i18n.i18n.translate('xpack.serverlessSearch.connectors.descriptionLabel', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "serverlessSearchEditDescriptionButton",
      size: "xs",
      onClick: () => setIsEditing(true)
    }, _i18n_string.EDIT_LABEL)
  }, isEditing ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "serverlessSearchEditDescriptionFieldText",
    onChange: event => setNewDescription(event.target.value),
    value: newDescription || ''
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s"
  }, connector.description))), isEditing && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
                  justify-content: center;
                `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchEditDescriptionButton",
    color: "primary",
    fill: true,
    onClick: () => mutate(newDescription),
    type: "submit",
    size: "s",
    isLoading: isLoading
  }, _i18n_string.SAVE_LABEL)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
                  justify-content: center;
                `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchEditDescriptionButton",
    size: "s",
    isLoading: isLoading,
    onClick: () => {
      setNewDescription(connector.description || '');
      setIsEditing(false);
    }
  }, _i18n_string.CANCEL_LABEL))))));
};
exports.EditDescription = EditDescription;