"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorIndexNameForm = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _validate_index_name = require("../../../../utils/validate_index_name");
var _use_index_name_search = require("../../../hooks/api/use_index_name_search");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorIndexNameForm = ({
  indexName,
  onChange,
  isDisabled
}) => {
  const [query, setQuery] = (0, _react.useState)('');
  const {
    data: indexNames,
    isLoading: isLoadingIndices,
    refetch
  } = (0, _use_index_name_search.useIndexNameSearch)(query);
  (0, _react.useEffect)(() => {
    refetch();
  }, [query, refetch]);
  const [newIndexName, setNewIndexName] = (0, _react.useState)(indexName);
  (0, _react.useEffect)(() => {
    onChange(newIndexName);
  }, [newIndexName, onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: !(0, _validate_index_name.isValidIndexName)(newIndexName || '') ? _i18n.i18n.translate('xpack.serverlessSearch.connectors.indexNameErrorText', {
      defaultMessage: 'Names should be lowercase and cannot contain spaces or special characters.'
    }) : undefined,
    isInvalid: !!newIndexName && !(0, _validate_index_name.isValidIndexName)(newIndexName),
    label: _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.indexNameLabel', {
      defaultMessage: 'Create or select an index'
    }),
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.serverlessSearch.connectors.indexNameInputHelpText', {
      defaultMessage: 'Names should be lowercase and cannot contain spaces or special characters.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    async: true,
    isClearable: false,
    customOptionText: _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.createIndexLabel', {
      defaultMessage: 'The connector will create the index {searchValue}',
      values: {
        searchValue: '{searchValue}'
      }
    }),
    isDisabled: isDisabled,
    isLoading: isLoadingIndices,
    onChange: values => {
      if (values[0].value) {
        setNewIndexName(values[0].value);
      }
    },
    onCreateOption: value => setNewIndexName(value),
    onSearchChange: value => setQuery(value),
    options: ((indexNames === null || indexNames === void 0 ? void 0 : indexNames.index_names) || []).map(name => ({
      label: name,
      value: name
    })),
    selectedOptions: newIndexName ? [{
      label: newIndexName,
      value: newIndexName
    }] : [],
    singleSelection: true
  })));
};
exports.ConnectorIndexNameForm = ConnectorIndexNameForm;