"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityPrivilegesForm = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _doc_links = require("../../../../common/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SecurityPrivilegesForm = ({
  roleDescriptors,
  onChangeRoleDescriptors,
  error
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "create-api-role-descriptors-code-editor-container"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "serverlessSearchSecurityPrivilegesFormLearnHowToStructureRoleDescriptorsLink",
    href: _doc_links.docLinks.roleDescriptors,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.roleDescriptorsLinkLabel', {
    defaultMessage: 'Learn how to structure role descriptors'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), error && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, error)), /*#__PURE__*/_react.default.createElement(_public.CodeEditorField, {
    allowFullScreen: true,
    fullWidth: true,
    height: "600px",
    languageId: "json",
    isCopyable: true,
    onChange: e => onChangeRoleDescriptors(e),
    value: roleDescriptors
  }));
};
exports.SecurityPrivilegesForm = SecurityPrivilegesForm;