"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readListPrivileges = exports.readListIndex = exports.importList = exports.findListsBySize = exports.findLists = exports.exportList = exports.deleteList = exports.createListIndex = void 0;
var _TaskEither = require("fp-ts/lib/TaskEither");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _fp_utils = require("../fp_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const version = '2023-10-31';
const findLists = async ({
  http,
  cursor,
  page,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  per_page,
  signal,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  sort_field,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  sort_order
}) => {
  return http.fetch(`${_securitysolutionListConstants.LIST_URL}/_find`, {
    method: 'GET',
    query: {
      cursor,
      page,
      per_page,
      sort_field,
      sort_order
    },
    signal,
    version
  });
};
const findListsWithValidation = async ({
  cursor,
  http,
  pageIndex,
  pageSize,
  signal,
  sortField,
  sortOrder
}) => (0, _pipeable.pipe)({
  cursor: cursor != null ? cursor.toString() : undefined,
  page: pageIndex != null ? pageIndex.toString() : undefined,
  per_page: pageSize != null ? pageSize.toString() : undefined,
  sort_field: sortField != null ? sortField.toString() : undefined,
  sort_order: sortOrder
}, payload => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.findListSchema, payload)), (0, _TaskEither.chain)(payload => (0, _TaskEither.tryCatch)(() => findLists({
  http,
  signal,
  ...payload
}), _fp_utils.toError)), (0, _TaskEither.chain)(response => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.foundListSchema, response))), (0, _function.flow)(_fp_utils.toPromise));
exports.findLists = findListsWithValidation;
const findListsBySize = async ({
  http,
  cursor,
  page,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  per_page,
  signal
}) => {
  return http.fetch(`${_securitysolutionListConstants.INTERNAL_FIND_LISTS_BY_SIZE}`, {
    method: 'GET',
    version: '1',
    query: {
      cursor,
      page,
      per_page
    },
    signal
  });
};
const findListsBySizeWithValidation = async ({
  cursor,
  http,
  pageIndex,
  pageSize,
  signal
}) => (0, _pipeable.pipe)({
  cursor: cursor != null ? cursor.toString() : undefined,
  page: pageIndex != null ? pageIndex.toString() : undefined,
  per_page: pageSize != null ? pageSize.toString() : undefined
}, payload => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.findListSchema, payload)), (0, _TaskEither.chain)(payload => (0, _TaskEither.tryCatch)(() => findListsBySize({
  http,
  signal,
  ...payload
}), _fp_utils.toError)), (0, _TaskEither.chain)(response => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.foundListsBySizeSchema, response))), (0, _function.flow)(_fp_utils.toPromise));
exports.findListsBySize = findListsBySizeWithValidation;
const importList = async ({
  file,
  http,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  list_id,
  type,
  signal
}) => {
  const formData = new FormData();
  formData.append('file', file);
  return http.fetch(`${_securitysolutionListConstants.LIST_ITEM_URL}/_import`, {
    body: formData,
    headers: {
      'Content-Type': undefined
    },
    method: 'POST',
    query: {
      list_id,
      type
    },
    signal,
    version
  });
};
const importListWithValidation = async ({
  file,
  http,
  listId,
  type,
  signal
}) => (0, _pipeable.pipe)({
  list_id: listId,
  type
}, query => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.importListItemQuerySchema, query)), (0, _TaskEither.chain)(query => (0, _pipeable.pipe)((0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.importListItemSchema, {
  file
})), (0, _TaskEither.map)(body => ({
  ...body,
  ...query
})))), (0, _TaskEither.chain)(payload => (0, _TaskEither.tryCatch)(() => importList({
  http,
  signal,
  ...payload
}), _fp_utils.toError)), (0, _TaskEither.chain)(response => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.listSchema, response))), _fp_utils.toPromise);
exports.importList = importListWithValidation;
const deleteList = async ({
  deleteReferences = false,
  http,
  id,
  ignoreReferences = false,
  signal
}) => http.fetch(_securitysolutionListConstants.LIST_URL, {
  method: 'DELETE',
  query: {
    deleteReferences,
    id,
    ignoreReferences
  },
  signal,
  version
});
const deleteListWithValidation = async ({
  deleteReferences,
  http,
  id,
  ignoreReferences,
  signal
}) => (0, _pipeable.pipe)({
  deleteReferences,
  id,
  ignoreReferences
}, payload => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.deleteListSchema, payload)), (0, _TaskEither.chain)(payload => (0, _TaskEither.tryCatch)(() => deleteList({
  http,
  signal,
  ...payload
}), _fp_utils.toError)), (0, _TaskEither.chain)(response => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.listSchema, response))), (0, _function.flow)(_fp_utils.toPromise));
exports.deleteList = deleteListWithValidation;
const exportList = async ({
  http,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  list_id,
  signal
}) => http.fetch(`${_securitysolutionListConstants.LIST_ITEM_URL}/_export`, {
  method: 'POST',
  query: {
    list_id
  },
  signal,
  version
});
const exportListWithValidation = async ({
  http,
  listId,
  signal
}) => (0, _pipeable.pipe)({
  list_id: listId
}, payload => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.exportListItemQuerySchema, payload)), (0, _TaskEither.chain)(payload => (0, _TaskEither.tryCatch)(() => exportList({
  http,
  signal,
  ...payload
}), _fp_utils.toError)), (0, _function.flow)(_fp_utils.toPromise));
exports.exportList = exportListWithValidation;
const readListIndex = async ({
  http,
  signal
}) => http.fetch(_securitysolutionListConstants.LIST_INDEX, {
  method: 'GET',
  signal,
  version
});
const readListIndexWithValidation = async ({
  http,
  signal
}) => (0, _function.flow)(() => (0, _TaskEither.tryCatch)(() => readListIndex({
  http,
  signal
}), _fp_utils.toError), (0, _TaskEither.chain)(response => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.listItemIndexExistSchema, response))), (0, _function.flow)(_fp_utils.toPromise))();
exports.readListIndex = readListIndexWithValidation;
// TODO add types and validation
const readListPrivileges = async ({
  http,
  signal
}) => http.fetch(_securitysolutionListConstants.LIST_PRIVILEGES_URL, {
  method: 'GET',
  signal,
  version
});
exports.readListPrivileges = readListPrivileges;
const createListIndex = async ({
  http,
  signal
}) => http.fetch(_securitysolutionListConstants.LIST_INDEX, {
  method: 'POST',
  signal,
  version
});
const createListIndexWithValidation = async ({
  http,
  signal
}) => (0, _function.flow)(() => (0, _TaskEither.tryCatch)(() => createListIndex({
  http,
  signal
}), _fp_utils.toError), (0, _TaskEither.chain)(response => (0, _TaskEither.fromEither)((0, _securitysolutionIoTsUtils.validateEither)(_securitysolutionIoTsListTypes.acknowledgeSchema, response))), (0, _function.flow)(_fp_utils.toPromise))();
exports.createListIndex = createListIndexWithValidation;